/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.block.entity.ExcavatingBlockEntityImpl;
import com.tom.createores.recipe.ExtractorRecipe;
import com.tom.createores.util.IOBlockType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ExtractorBlockEntity
extends ExcavatingBlockEntityImpl<ExtractorRecipe> {
    private Tank fluidTankOut = new Tank();
    private LazyOptional<FluidTank> tankCapOut = LazyOptional.of(() -> this.fluidTankOut);

    public ExtractorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCaps(Capability<T> cap, IOBlockType type) {
        if (type == IOBlockType.FLUID_OUT && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankCapOut.cast();
        }
        return super.getCaps(cap, type);
    }

    @Override
    protected boolean canExtract() {
        return super.canExtract() && this.fluidTankOut.fillInternal(((ExtractorRecipe)this.current).getOutput(), IFluidHandler.FluidAction.SIMULATE) == ((ExtractorRecipe)this.current).getOutput().getAmount();
    }

    @Override
    protected void onFinished() {
        this.fluidTankOut.fillInternal(((ExtractorRecipe)this.current).getOutput(), IFluidHandler.FluidAction.EXECUTE);
        super.onFinished();
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTankOut.readFromNBT(tag.m_128469_("tank"));
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("tank", (Tag)this.fluidTankOut.writeToNBT(new CompoundTag()));
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.extractor.output")));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tankCapOut.cast());
        return true;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.tankCapOut.invalidate();
    }

    @Override
    protected RecipeType<ExtractorRecipe> getRecipeType() {
        return CreateOreExcavation.EXTRACTING_RECIPES.getRecipeType();
    }

    @Override
    protected String getTankInName() {
        return "tankIn";
    }

    private class Tank
    extends FluidTank {
        public Tank() {
            super(16000);
        }

        protected void onContentsChanged() {
            ExtractorBlockEntity.this.notifyUpdate();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    }
}

