/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.tom.createores.Registration;
import com.tom.createores.menu.OreVeinAtlasMenu;
import com.tom.createores.network.OreVeinAtlasClickPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.PlatformMenuProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OreVeinAtlasItem
extends Item
implements PlatformMenuProvider {
    public static final String DISCOVERED = "discovered";
    public static final String EXCLUDE = "exclude";
    public static final String VEINS = "veins";
    public static final String TARGET = "veinTarget";
    public static final String SIZE = "size";
    public static final String DIMENSION = "dim";
    public static final String POS_X = "x";
    public static final String POS_Z = "z";
    public static final String VEIN_ID = "id";

    public OreVeinAtlasItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void addVein(Player player, ItemStack is, VeinRecipe vein, DimChunkPos pos, float randomMul) {
        player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.addedToAtlas"), false);
        CompoundTag tag = is.m_41784_();
        ListTag disc = tag.m_128437_(DISCOVERED, 8);
        tag.m_128365_(DISCOVERED, (Tag)disc);
        String id = vein.m_6423_().toString();
        boolean found = false;
        for (int i = 0; i < disc.size(); ++i) {
            String v = disc.m_128778_(i);
            if (!id.equals(v)) continue;
            found = true;
            break;
        }
        if (!found) {
            disc.add((Object)StringTag.m_129297_((String)id));
        }
        ListTag veins = tag.m_128437_(VEINS, 10);
        tag.m_128365_(VEINS, (Tag)veins);
        String dimId = pos.dimension.m_135782_().toString();
        found = false;
        for (int i = 0; i < veins.size(); ++i) {
            CompoundTag v = veins.m_128728_(i);
            int x = v.m_128451_(POS_X);
            int z = v.m_128451_(POS_Z);
            String vid = v.m_128461_(VEIN_ID);
            String dim = v.m_128461_(DIMENSION);
            if (!dimId.equals(dim) || x != pos.x || z != pos.z) continue;
            if (!vid.equals(id)) {
                v.m_128359_(VEIN_ID, id);
            }
            v.m_128350_(SIZE, randomMul);
            found = true;
            break;
        }
        if (!found) {
            CompoundTag t = new CompoundTag();
            t.m_128405_(POS_X, pos.x);
            t.m_128405_(POS_Z, pos.z);
            t.m_128359_(DIMENSION, dimId);
            t.m_128359_(VEIN_ID, id);
            veins.add((Object)t);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            player.m_5893_((MenuProvider)this);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        ItemStack heldItem = pPlayer.m_21205_();
        return new OreVeinAtlasMenu((MenuType)Registration.VEIN_ATLAS_MENU.get(), pContainerId, pPlayerInventory, heldItem);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    public void menuClicked(ItemStack is, OreVeinAtlasClickPacket.Option opt, ResourceLocation id) {
        CompoundTag tag = is.m_41784_();
        switch (opt) {
            case ADD_EXCLUDE: {
                ListTag ex = tag.m_128437_(EXCLUDE, 8);
                tag.m_128365_(EXCLUDE, (Tag)ex);
                ex.add((Object)StringTag.m_129297_((String)id.toString()));
                break;
            }
            case REMOVE_EXCLUDE: {
                ListTag ex = tag.m_128437_(EXCLUDE, 8);
                tag.m_128365_(EXCLUDE, (Tag)ex);
                String st = id.toString();
                ex.removeIf(t -> {
                    StringTag s;
                    return t instanceof StringTag && (s = (StringTag)t).m_7916_().equals(st);
                });
                break;
            }
            case REMOVE_TARGET: {
                tag.m_128473_(TARGET);
                break;
            }
            case SET_TARGET: {
                tag.m_128359_(TARGET, id.toString());
                ListTag ex = tag.m_128437_(EXCLUDE, 8);
                tag.m_128365_(EXCLUDE, (Tag)ex);
                String st = id.toString();
                ex.removeIf(t -> {
                    StringTag s;
                    return t instanceof StringTag && (s = (StringTag)t).m_7916_().equals(st);
                });
                break;
            }
        }
    }
}

