/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.createores.menu.OreVeinAtlasMenu;
import com.tom.createores.menu.PagedListWidget;
import com.tom.createores.network.NetworkHandler;
import com.tom.createores.network.OreVeinAtlasClickPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.ThreeState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OreVeinAtlasScreen
extends AbstractContainerScreen<OreVeinAtlasMenu> {
    private static final ResourceLocation GUI_TEXTURES = ResourceLocation.m_214293_((String)"createoreexcavation", (String)"textures/gui/atlas.png");
    private static final ResourceLocation EXCLUDE = ResourceLocation.m_214293_((String)"createoreexcavation", (String)"textures/gui/atlas_exclude.png");
    private static final ResourceLocation TARGET = ResourceLocation.m_214293_((String)"createoreexcavation", (String)"textures/gui/atlas_target.png");
    private static final ResourceLocation BUTTON_LOCATION = ResourceLocation.m_214293_((String)"createoreexcavation", (String)"textures/gui/atlas_buttons.png");
    private static final Button.OnPress NULL_PRESS = b -> {};
    private List<Vein> veinsList = new ArrayList<Vein>();
    private List<VeinRecipe> veinTypesList = new ArrayList<VeinRecipe>();
    private List<Vein> veinsListSorted = new ArrayList<Vein>();
    private List<VeinRecipe> veinTypesListSorted = new ArrayList<VeinRecipe>();
    private Set<ResourceLocation> excluded = new HashSet<ResourceLocation>();
    private String target;
    private VeinsListWidget discovered;
    private VeinTypesListWidget veinTypes;
    private Component veinTypesTitle = Component.m_237115_((String)"info.coe.atlas.vein_types");
    private PageButton backButton;
    private Vein selected;

    public OreVeinAtlasScreen(OreVeinAtlasMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super((AbstractContainerMenu)p_97741_, p_97742_, p_97743_);
    }

    protected void m_7286_(GuiGraphics gr, float partial, int mx, int my) {
        gr.m_280163_(GUI_TEXTURES, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
    }

    protected void m_7856_() {
        this.f_97726_ = 282;
        this.f_97727_ = 182;
        super.m_7856_();
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.discovered = (VeinsListWidget)this.m_142416_((GuiEventListener)new VeinsListWidget(i + 20, j + 24, 110, 140));
        this.veinTypes = (VeinTypesListWidget)this.m_142416_((GuiEventListener)new VeinTypesListWidget(i + 150, j + 24, 110, 140));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(i + 20 + 4, j + 24 + 140 - 12, false, p_98287_ -> this.pageBack(), true));
        this.backButton.f_93623_ = false;
        this.discovered.list = () -> this.veinsListSorted;
        this.veinTypes.list = () -> this.veinTypesListSorted;
        this.fillLists();
        this.updateVeinsList();
        this.updateVeinTypesList();
        this.discovered.updateContent();
        this.veinTypes.updateContent();
    }

    private void pageBack() {
        this.backButton.f_93623_ = false;
        this.discovered.setVisible(true);
        this.selected = null;
    }

    private void updateVeinTypesList() {
        this.veinTypesListSorted.clear();
        this.veinTypesListSorted.addAll(this.veinTypesList);
        this.veinTypes.updateContent();
    }

    private void updateVeinsList() {
        this.veinsListSorted.clear();
        this.veinsListSorted.addAll(this.veinsList);
        this.discovered.updateContent();
    }

    private void fillLists() {
        ResourceLocation v;
        int i;
        this.veinsList.clear();
        this.veinTypesList.clear();
        this.excluded.clear();
        ItemStack is = ((OreVeinAtlasMenu)this.f_97732_).getHeldItem();
        CompoundTag tag = is.m_41783_();
        if (tag == null) {
            return;
        }
        this.target = tag.m_128461_("veinTarget");
        ListTag disc = tag.m_128437_("discovered", 8);
        ListTag veins = tag.m_128437_("veins", 10);
        ListTag exc = tag.m_128437_("exclude", 8);
        for (i = 0; i < disc.size(); ++i) {
            v = ResourceLocation.m_135820_((String)disc.m_128778_(i));
            Object var9_10 = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(v).orElse(null);
            if (!(var9_10 instanceof VeinRecipe)) continue;
            VeinRecipe vr = var9_10;
            this.veinTypesList.add(vr);
        }
        for (i = 0; i < veins.size(); ++i) {
            v = veins.m_128728_(i);
            int x = v.m_128451_("x");
            int z = v.m_128451_("z");
            ResourceLocation vid = ResourceLocation.m_135820_((String)v.m_128461_("id"));
            ResourceLocation dim = ResourceLocation.m_135820_((String)v.m_128461_("dim"));
            DimChunkPos pos = new DimChunkPos((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim), x, z);
            float size = v.m_128457_("size");
            Object var15_17 = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(vid).orElse(null);
            if (!(var15_17 instanceof VeinRecipe)) continue;
            VeinRecipe vr = var15_17;
            this.veinsList.add(new Vein(pos, vr, size));
        }
        for (i = 0; i < exc.size(); ++i) {
            v = ResourceLocation.m_135820_((String)exc.m_128778_(i));
            if (v == null) continue;
            this.excluded.add(v);
        }
    }

    public void m_88315_(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(st);
        super.m_88315_(st, mouseX, mouseY, partialTicks);
        if (this.selected != null) {
            st.m_280168_().m_85836_();
            st.m_280168_().m_252880_((float)(this.f_97735_ + 60), (float)(this.f_97736_ + 40), 0.0f);
            float f = 2.0f;
            st.m_280168_().m_85841_(f, f, f);
            st.m_280480_(this.selected.recipe.icon, 0, 0);
            st.m_280168_().m_85849_();
            Component t = this.selected.recipe.veinName;
            st.m_280614_(this.f_96547_, t, this.f_97735_ + 75 - this.f_96547_.m_92852_((FormattedText)t) / 2, this.f_97736_ + 80, 0x404040, false);
            long size = this.getVeinSize();
            t = size == 0L ? Component.m_237115_((String)"info.coe.atlas.vein_size.infinite") : Component.m_237113_((String)("~" + NumberFormatter.formatNumber(size)));
            t = Component.m_237110_((String)"info.coe.atlas.vein_size", (Object[])new Object[]{t});
            st.m_280614_(this.f_96547_, t, this.f_97735_ + 15, this.f_97736_ + 100, 0x404040, false);
            t = Component.m_237115_((String)"info.coe.atlas.location");
            st.m_280614_(this.f_96547_, t, this.f_97735_ + 15, this.f_97736_ + 110, 0x404040, false);
            t = Component.m_237110_((String)"info.coe.atlas.location2", (Object[])new Object[]{Math.round((float)(this.selected.pos.x * 16 + 8) / 10.0f) * 10, Math.round((float)(this.selected.pos.z * 16 + 8) / 10.0f) * 10});
            st.m_280614_(this.f_96547_, t, this.f_97735_ + 25, this.f_97736_ + 120, 0x404040, false);
            t = Component.m_237110_((String)"info.coe.atlas.dimension", (Object[])new Object[]{this.selected.pos.dimension.m_135782_().toString()});
            st.m_280614_(this.f_96547_, t, this.f_97735_ + 15, this.f_97736_ + 130, 0x404040, false);
        }
    }

    private long getVeinSize() {
        if (this.selected.recipe.isFinite() != ThreeState.NEVER) {
            if (this.selected.recipe.isFinite() == ThreeState.DEFAULT && ((OreVeinAtlasMenu)this.f_97732_).isDefaultInfinite()) {
                return 0L;
            }
            double mul = (this.selected.recipe.getMaxAmount() - this.selected.recipe.getMinAmount()) * this.selected.size + this.selected.recipe.getMinAmount();
            long am = Math.round(mul * (double)((OreVeinAtlasMenu)this.f_97732_).getFiniteBase());
            return am;
        }
        return 0L;
    }

    protected void m_280003_(GuiGraphics gr, int pMouseX, int pMouseY) {
        gr.m_280614_(this.f_96547_, this.f_96539_, 75 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 16, 0x404040, false);
        gr.m_280614_(this.f_96547_, this.veinTypesTitle, 205 - this.f_96547_.m_92852_((FormattedText)this.veinTypesTitle) / 2, 16, 0x404040, false);
    }

    public void exclude(VeinRecipe data, boolean ex) {
        if (ex) {
            this.excluded.add(data.id);
            this.target = null;
            this.send(OreVeinAtlasClickPacket.Option.ADD_EXCLUDE, data.id);
        } else {
            this.excluded.remove(data.id);
            this.send(OreVeinAtlasClickPacket.Option.REMOVE_EXCLUDE, data.id);
        }
        this.veinTypes.updateContent();
    }

    private void send(OreVeinAtlasClickPacket.Option opt, ResourceLocation id) {
        NetworkHandler.sendDataToServer(new OreVeinAtlasClickPacket(opt, id));
    }

    public void target(VeinRecipe data) {
        if (data != null) {
            this.target = data.id.toString();
            this.send(OreVeinAtlasClickPacket.Option.SET_TARGET, data.id);
        } else {
            this.target = null;
            this.send(OreVeinAtlasClickPacket.Option.REMOVE_TARGET, null);
        }
        this.veinTypes.updateContent();
    }

    private class VeinsListWidget
    extends PagedListWidget<VeinWidgetHolder, Vein> {
        public VeinsListWidget(int x, int y, int w, int h) {
            super(x, y, w, h, 20);
        }

        @Override
        protected <W extends AbstractWidget> W addWidgetToGUI(W w) {
            return (W)((AbstractWidget)OreVeinAtlasScreen.this.m_142416_(w));
        }

        @Override
        protected VeinWidgetHolder makeElement(int x, int y) {
            return new VeinWidgetHolder((VeinInfoButton)OreVeinAtlasScreen.this.m_142416_((GuiEventListener)new VeinInfoButton(x, y, 110)));
        }

        @Override
        protected void updateElement(VeinWidgetHolder element, Vein data) {
            boolean bl = element.btn.f_93624_ = data != null;
            if (data != null) {
                element.btn.setVein(data);
            }
        }
    }

    private class VeinTypesListWidget
    extends PagedListWidget<VeinTypeWidgetHolder, VeinRecipe> {
        public VeinTypesListWidget(int x, int y, int w, int h) {
            super(x, y, w, h, 10);
        }

        @Override
        protected <W extends AbstractWidget> W addWidgetToGUI(W w) {
            return (W)((AbstractWidget)OreVeinAtlasScreen.this.m_142416_(w));
        }

        @Override
        protected VeinTypeWidgetHolder makeElement(int x, int y) {
            return new VeinTypeWidgetHolder((VeinTargetButton)OreVeinAtlasScreen.this.m_142416_((GuiEventListener)new VeinTargetButton(x, y, 100)), (VeinExcludeButton)OreVeinAtlasScreen.this.m_142416_((GuiEventListener)new VeinExcludeButton(x + 100, y)));
        }

        @Override
        protected void updateElement(VeinTypeWidgetHolder element, VeinRecipe data) {
            element.btn.f_93624_ = data != null;
            boolean bl = element.trg.f_93624_ = data != null;
            if (data != null) {
                element.btn.recipe = data;
                element.btn.m_93666_(data.getName());
                element.btn.m_257936_();
                element.trg.data = data;
                element.trg.m_257936_();
            }
        }
    }

    private record Vein(DimChunkPos pos, VeinRecipe recipe, float size) {
    }

    private record VeinTypeWidgetHolder(VeinTargetButton btn, VeinExcludeButton trg) {
    }

    private class VeinExcludeButton
    extends Button {
        private VeinRecipe data;
        private Tooltip TT_EXCLUDE;
        private Tooltip TT_INCLUDE;

        protected VeinExcludeButton(int pX, int pY) {
            super(pX, pY, 10, 10, (Component)Component.m_237119_(), NULL_PRESS, f_252438_);
            this.TT_EXCLUDE = Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.coe.atlas.exclude"));
            this.TT_INCLUDE = Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.coe.atlas.include"));
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.m_280027_(BUTTON_LOCATION, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getBtnTextureY());
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id)) {
                pGuiGraphics.m_280411_(EXCLUDE, this.m_252754_() + 1, this.m_252907_() + 1, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        private int getBtnTextureY() {
            int i = 1;
            if (!this.f_93623_) {
                i = 0;
            } else if (this.m_198029_()) {
                i = 2;
            }
            return 106 + i * 20;
        }

        public void m_5691_() {
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id)) {
                OreVeinAtlasScreen.this.exclude(this.data, false);
            } else {
                OreVeinAtlasScreen.this.exclude(this.data, true);
            }
        }

        public Tooltip createTooltip() {
            if (OreVeinAtlasScreen.this.excluded.contains(this.data.id)) {
                return this.TT_EXCLUDE;
            }
            return this.TT_INCLUDE;
        }

        public void m_257936_() {
            this.m_257544_(this.createTooltip());
        }
    }

    private class VeinTargetButton
    extends VeinTypeButton {
        private Tooltip TT_TARGET;
        private Tooltip TT_SWITCH_TARGET;
        private Tooltip TT_SET_TARGET;

        private VeinTargetButton(int pX, int pY, int pWidth) {
            super(pX, pY, pWidth, 10);
            this.TT_TARGET = Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.coe.atlas.target"));
            this.TT_SWITCH_TARGET = Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.coe.atlas.switch_target"));
            this.TT_SET_TARGET = Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.coe.atlas.set_target"));
        }

        @Override
        protected void renderItem(GuiGraphics pGuiGraphics) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 1), (float)(this.m_252907_() + 1), 0.0f);
            float f = 0.5f;
            pGuiGraphics.m_280168_().m_85841_(f, f, f);
            pGuiGraphics.m_280480_(this.recipe.icon, 0, 0);
            pGuiGraphics.m_280168_().m_85849_();
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty() && OreVeinAtlasScreen.this.target.equals(this.recipe.id.toString())) {
                pGuiGraphics.m_280411_(TARGET, this.m_252754_() + 10, this.m_252907_() + 1, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        @Override
        public Tooltip createTooltip() {
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty()) {
                if (OreVeinAtlasScreen.this.target.equals(this.recipe.id.toString())) {
                    return this.TT_TARGET;
                }
                return this.TT_SWITCH_TARGET;
            }
            return this.TT_SET_TARGET;
        }

        @Override
        public void m_5691_() {
            if (OreVeinAtlasScreen.this.target != null && !OreVeinAtlasScreen.this.target.isEmpty()) {
                if (OreVeinAtlasScreen.this.target.equals(this.recipe.id.toString())) {
                    OreVeinAtlasScreen.this.target(null);
                } else {
                    OreVeinAtlasScreen.this.target(this.recipe);
                }
            } else {
                OreVeinAtlasScreen.this.target(this.recipe);
            }
        }
    }

    private class VeinInfoButton
    extends VeinTypeButton {
        private Vein vein;

        private VeinInfoButton(int pX, int pY, int pWidth) {
            super(pX, pY, pWidth, 20);
        }

        @Override
        public void m_5691_() {
            OreVeinAtlasScreen.this.discovered.setVisible(false);
            OreVeinAtlasScreen.this.backButton.f_93623_ = true;
            OreVeinAtlasScreen.this.selected = this.vein;
        }

        public void setVein(Vein vein) {
            this.vein = vein;
            this.recipe = vein.recipe;
            this.m_93666_(vein.recipe.getName());
        }
    }

    private class VeinTypeButton
    extends Button {
        protected VeinRecipe recipe;

        private VeinTypeButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_(), NULL_PRESS, f_252438_);
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.m_280027_(BUTTON_LOCATION, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getBtnTextureY());
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
            this.renderScrollingText(pGuiGraphics, minecraft.f_91062_, 20, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            this.renderItem(pGuiGraphics);
        }

        protected void renderItem(GuiGraphics pGuiGraphics) {
            pGuiGraphics.m_280480_(this.recipe.icon, this.m_252754_() + 1, this.m_252907_() + 1);
        }

        protected void renderScrollingText(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor) {
            int i = this.m_252754_() + pWidth;
            int j = this.m_252754_() + this.m_5711_();
            VeinTypeButton.m_280138_((GuiGraphics)pGuiGraphics, (Font)pFont, (Component)this.m_6035_(), (int)i, (int)this.m_252907_(), (int)j, (int)(this.m_252907_() + this.m_93694_()), (int)pColor);
        }

        private int getBtnTextureY() {
            int i = 1;
            if (!this.f_93623_) {
                i = 0;
            } else if (this.m_198029_()) {
                i = 2;
            }
            return 46 + i * 20;
        }

        public Tooltip createTooltip() {
            return null;
        }

        public void m_257936_() {
            this.m_257544_(this.createTooltip());
        }

        public void m_5691_() {
        }
    }

    private record VeinWidgetHolder(VeinInfoButton btn) {
    }
}

