/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Slide;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.Easing;
import net.minecraft.world.entity.player.Player;

public class SlidingAnimator
extends Animator {
    private static final int MAX_TRANSITION_TICK = 5;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Slide.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float animFactor = ((float)this.getTick() + transformer.getPartialTick()) / 5.0f;
        if (animFactor > 1.0f) {
            animFactor = 1.0f;
        }
        animFactor = new Easing(animFactor).sinInOut(0.0f, 1.0f, 0.0f, 1.0f).get();
        transformer.rotateHeadPitch(50.0f).rotateRightArm((float)Math.toRadians(45.0), 0.0f, (float)Math.toRadians(110.0), animFactor).rotateLeftArm((float)Math.toRadians(50.0), 0.0f, (float)Math.toRadians(-100.0), animFactor).rotateRightLeg((float)Math.toRadians(-17.0), 0.0f, (float)Math.toRadians(-5.0), animFactor).rotateLeftLeg((float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(15.0), animFactor).makeLegsLittleMoving().makeArmsNatural().end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float swimAmount = player.m_20998_(rotator.getPartialTick());
        float bodyAnglePhase = ((float)this.getTick() + rotator.getPartialTick()) / 5.0f;
        if (bodyAnglePhase > 1.0f) {
            bodyAnglePhase = 1.0f;
        }
        float bodyAngleFactor = new Easing(bodyAnglePhase).squareOut(0.0f, 1.0f, 0.0f, 1.0f).get();
        rotator.startBasedCenter().translate(0.0f, player.m_20206_() * 2.0f, -player.m_20206_() * 0.5f).rotatePitchFrontward(-70.0f * bodyAngleFactor - 90.0f * swimAmount).end();
    }
}

