/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.handlers;

import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.StartBreakfallMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerFallHandler {
    @SubscribeEvent
    public static void onDamage(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        if (parkourability.get(BreakfallReady.class).isDoing() && (parkourability.getActionInfo().can(Tap.class) || parkourability.getActionInfo().can(Roll.class))) {
            boolean justTime = parkourability.get(BreakfallReady.class).getDoingTick() < 5;
            float distance = event.getDistance();
            if (distance > 2.0f) {
                StartBreakfallMessage.send(player, justTime);
            }
            if (distance < 6.0f || justTime && distance < 8.0f) {
                event.setCanceled(true);
            } else {
                event.setDamageMultiplier(event.getDamageMultiplier() * (justTime ? 0.4f : 0.6f));
            }
        }
    }
}

