/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.paraglider;

import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.extern.paraglider.ParagliderStamina;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import tictim.paraglider.api.item.Paraglider;

public class ParagliderManager {
    private static boolean paragliderInstalled = false;

    public static boolean isParagliderInstalled() {
        return paragliderInstalled;
    }

    public static void init() {
        IModFileInfo mod = ModList.get().getModFileById("paraglider");
        paragliderInstalled = mod != null;
    }

    @Nullable
    public static IStamina newParagliderStaminaFor(Player player) {
        if (!paragliderInstalled) {
            return null;
        }
        return new ParagliderStamina(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isUsingParaglider(Player player) {
        return paragliderInstalled && IStamina.get(player) instanceof ParagliderStamina;
    }

    public static boolean isFallingWithParaglider(Player player) {
        if (ParagliderManager.isParagliderInstalled()) {
            ItemStack stack;
            Paraglider paragliderItem;
            Item item = player.m_21205_().m_41720_();
            if (item instanceof Paraglider) {
                Paraglider p;
                paragliderItem = p = (Paraglider)item;
                stack = player.m_21205_();
            } else {
                item = player.m_21206_().m_41720_();
                if (item instanceof Paraglider) {
                    Paraglider p;
                    paragliderItem = p = (Paraglider)item;
                    stack = player.m_21205_();
                } else {
                    return false;
                }
            }
            return paragliderItem.isParagliding(stack);
        }
        return false;
    }
}

