/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import org.jetbrains.annotations.Nullable;
import satisfy.bloomingnature.registry.ObjectRegistry;

public class SnowyFirLeavesBlock
extends SnowyDirtBlock {
    public static final BooleanProperty SNOWY = SnowyDirtBlock.f_56637_;

    public SnowyFirLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(true)));
    }

    private static boolean canBeGrass(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockState blockState2 = levelReader.m_8055_(blockPos2);
        if (blockState2.m_60713_(Blocks.f_50125_) && (Integer)blockState2.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState2.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)levelReader, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.m_60739_((BlockGetter)levelReader, blockPos2));
        return i < levelReader.m_7469_();
    }

    private static boolean canPropagate(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        return SnowyFirLeavesBlock.canBeGrass(blockState, levelReader, blockPos) && !levelReader.m_6425_(blockPos2).m_205070_(FluidTags.f_13131_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(true));
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!SnowyFirLeavesBlock.canBeGrass(blockState, (LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46597_(blockPos, ((Block)ObjectRegistry.FIR_LEAVES.get()).m_49966_());
        } else if (serverLevel.m_46803_(blockPos.m_7494_()) >= 9) {
            BlockState blockState2 = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos2 = blockPos.m_7918_(randomSource.m_188503_(3) - 1, randomSource.m_188503_(5) - 3, randomSource.m_188503_(3) - 1);
                if (!serverLevel.m_8055_(blockPos2).m_60713_((Block)ObjectRegistry.FIR_LEAVES.get()) || !SnowyFirLeavesBlock.canPropagate(blockState2, (LevelReader)serverLevel, blockPos2)) continue;
                serverLevel.m_46597_(blockPos2, (BlockState)blockState2.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(serverLevel.m_8055_(blockPos2.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }
}

