/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import satisfy.bloomingnature.entity.TermiteEntity;
import satisfy.bloomingnature.registry.EntityRegistry;

public class TermiteBlock
extends Block {
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public TermiteBlock(Block block, BlockBehaviour.Properties properties) {
        super(properties.m_155954_(block.m_155943_() / 2.0f).m_155956_(0.75f));
        this.hostBlock = block;
        BLOCK_BY_HOST_BLOCK.put(block, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(BlockState blockState) {
        return BLOCK_BY_HOST_BLOCK.containsKey(blockState.m_60734_());
    }

    private void spawnInfestation(ServerLevel serverLevel, BlockPos blockPos) {
        TermiteEntity termiteEntity = new TermiteEntity((EntityType<? extends Silverfish>)((EntityType)EntityRegistry.TERMITE.get()), (Level)serverLevel);
        if (termiteEntity != null) {
            termiteEntity.m_7678_((double)blockPos.m_123341_() + 0.4, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
            serverLevel.m_7967_((Entity)termiteEntity);
            termiteEntity.m_21373_();
        }
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        if (serverLevel.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) == 0 && serverLevel.f_46441_.m_188501_() < 0.5f) {
            int numTermites = serverLevel.f_46441_.m_188503_(2) + 3;
            for (int i = 0; i < numTermites; ++i) {
                this.spawnInfestation(serverLevel, blockPos);
            }
        }
    }

    public static BlockState infestedStateByHost(BlockState blockState) {
        return TermiteBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, blockState, () -> BLOCK_BY_HOST_BLOCK.get(blockState.m_60734_()).m_49966_());
    }

    public BlockState hostStateByInfested(BlockState blockState) {
        return TermiteBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, blockState, () -> this.getHostBlock().m_49966_());
    }

    private static BlockState getNewStateWithProperties(Map<BlockState, BlockState> map, BlockState blockState, Supplier<BlockState> supplier) {
        return map.computeIfAbsent(blockState, blockStatex -> {
            BlockState blockState2 = (BlockState)supplier.get();
            for (Property property : blockStatex.m_61147_()) {
                blockState2 = blockState2.m_61138_(property) ? (BlockState)blockState2.m_61124_(property, blockStatex.m_61143_(property)) : blockState2;
            }
            return blockState2;
        });
    }
}

