/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Pig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

@OnlyIn(value=Dist.CLIENT)
public class BoarModel<T extends Pig>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new BloomingNatureIdentifier("boar"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public BoarModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightHindLeg = root.m_171324_("rightHindLeg");
        this.leftHindLeg = root.m_171324_("leftHindLeg");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-3.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -3.0f, -10.0f, 16.0f, 11.0f, 20.0f, new CubeDeformation(0.02f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)6.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition mane = body.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(18, 61).m_171488_(0.0f, -26.0f, -10.0f, 0.0f, 10.0f, 19.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)3.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-4.0f, -4.3807f, -15.3061f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 31).m_171488_(-5.0f, -6.3807f, -11.3061f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(-5.0f, -7.3807f, -14.3061f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(58, 31).m_171488_(3.0f, -7.3807f, -14.3061f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-2.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition right_Ear = head.m_171599_("right_Ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_Ear_r1 = right_Ear.m_171599_("right_Ear_r1", CubeListBuilder.m_171558_().m_171514_(52, 9).m_171488_(0.0346f, -5.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.9769f, (float)2.4403f, (float)-9.4924f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition left_Ear = head.m_171599_("left_Ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.9769f, (float)2.4403f, (float)-9.4924f));
        PartDefinition left_Ear_r1 = left_Ear.m_171599_("left_Ear_r1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-5.0346f, -5.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-14.0f, -2.0f, -2.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)16.0f, (float)9.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(9.0f, -2.0f, -3.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)16.0f, (float)10.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(24, 48).m_171488_(-2.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)12.0f, (float)-3.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-4.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)12.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private static ModelPart safeGetChild(ModelPart part, String childName) {
        if (part == null) {
            throw new IllegalArgumentException("Part " + childName + " could not be initialized because its parent is null.");
        }
        return part.m_171324_(childName);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    public void setupAnim(T mob, float f, float g, float h, float i, float j) {
        this.head.f_104204_ = i * ((float)Math.PI / 180);
        float l = 1.0f;
        this.head.f_104201_ = mob.m_6162_() ? Mth.m_14179_((float)l, (float)2.0f, (float)5.0f) : 2.0f;
        float m = 1.2f;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)f) * 1.2f * g;
        this.rightHindLeg.f_104203_ = this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(f + (float)Math.PI)) * 1.2f * g;
        this.leftHindLeg.f_104203_ = this.rightFrontLeg.f_104203_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.body;
    }
}

