/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import satisfy.bloomingnature.entity.OwlEntity;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

public class OwlModel
extends AgeableListModel<OwlEntity>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new BloomingNatureIdentifier("owl"), "main");
    private final ModelPart leg_right;
    private final ModelPart leg_left;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart wing_right;
    private final ModelPart wing_left;

    public OwlModel(ModelPart root) {
        super(true, 14.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.wing_right = this.body.m_171324_("wing_right");
        this.wing_left = this.body.m_171324_("wing_left");
        this.leg_right = this.body.m_171324_("leg_right");
        this.leg_left = this.body.m_171324_("leg_left");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.8532f, (float)-0.6407f));
        PartDefinition torso_r1 = body.m_171599_("torso_r1", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171480_().m_171488_(-3.5f, -2.475f, -3.75f, 7.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(5, 38).m_171488_(-7.059f, 4.0f, 3.3f, 7.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.559f, (float)3.2079f, (float)-2.2761f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailWing = body.m_171599_("tailWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.6761f, (float)-1.1119f));
        PartDefinition cube_r2 = tailWing.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-3.5f, -2.5858f, 0.2071f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.4225f, (float)2.1273f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right = body.m_171599_("wing_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_right_r1 = wing_right.m_171599_("wing_right_r1", CubeListBuilder.m_171558_().m_171514_(14, 9).m_171480_().m_171488_(-0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left = body.m_171599_("wing_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_left_r1 = wing_left.m_171599_("wing_left_r1", CubeListBuilder.m_171558_().m_171514_(14, 9).m_171488_(0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = body.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(23, 4).m_171488_(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(27, 4).m_171488_(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171480_().m_171488_(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition leg_left = body.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(23, 4).m_171480_().m_171488_(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(27, 4).m_171488_(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171488_(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.525f, -4.25f, -3.0833f, 7.05f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(6, 11).m_171488_(-3.525f, 0.75f, -3.0833f, 7.05f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 11).m_171480_().m_171488_(-0.5f, -1.25f, -4.0833f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)15.2517f, (float)-2.269f));
        PartDefinition right_horn_r1 = head.m_171599_("right_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171488_(-1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_horn_r1 = head.m_171599_("left_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float pi = (float)Math.PI;
        if (entity.getStandingState() != OwlEntity.StandingState.FLYING) {
            this.head.f_104203_ = -0.2618f + headPitch * 0.0175f;
            this.head.f_104204_ = netHeadYaw * 0.0175f;
            this.wing_left.f_104205_ = 0.0f;
            this.wing_right.f_104205_ = 0.0f;
            this.leg_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leg_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * 1.4f * limbSwingAmount;
            float wingSwingAmountNonFlying = 0.5f;
            this.wing_right.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * wingSwingAmountNonFlying;
            this.wing_left.f_104204_ = -Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * wingSwingAmountNonFlying;
            if (entity.m_21825_()) {
                this.leg_right.f_104203_ = -1.5f;
                this.leg_left.f_104203_ = 1.5f;
            }
        } else {
            float wingSwingAmountFlying = 1.0f;
            this.wing_left.f_104204_ = Mth.m_14089_((float)(limbSwing / 2.0f)) * wingSwingAmountFlying;
            this.wing_right.f_104204_ = -Mth.m_14089_((float)(limbSwing / 2.0f)) * wingSwingAmountFlying;
            this.wing_left.f_104205_ = -(Mth.m_14031_((float)(limbSwing / 2.0f)) / 4.0f);
            this.wing_right.f_104205_ = Mth.m_14031_((float)(limbSwing / 2.0f)) / 4.0f;
            this.leg_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount;
            this.leg_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + pi)) * 1.0f * limbSwingAmount;
        }
    }

    public void prepareMobModel(OwlEntity entity, float limbAngle, float limbDistance, float delta) {
        super.m_6839_((Entity)entity, limbAngle, limbDistance, delta);
        switch (entity.getStandingState()) {
            case STANDING: {
                break;
            }
        }
        float rad90 = 1.5708f;
        float rad40 = 0.698132f;
        float leanProgress = entity.m_20998_(delta) / 7.0f;
        this.setRotationAngle(this.leg_left, rad90 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.leg_right, rad90 * leanProgress, 0.0f, 0.0f);
        this.setRotationAngle(this.head, -rad40 * leanProgress, 0.0f, 0.0f);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setRotationAngle(ModelPart part, float x, float y, float z) {
        part.f_104203_ = x;
        part.f_104204_ = y;
        part.f_104205_ = z;
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

