/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

public class PelicanModel<T extends Entity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new BloomingNatureIdentifier("pelican"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart wing0;
    private final ModelPart wing1;
    private final ModelPart beak;

    public PelicanModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leg0 = root.m_171324_("leg0");
        this.leg1 = root.m_171324_("leg1");
        this.wing0 = root.m_171324_("wing0");
        this.wing1 = root.m_171324_("wing1");
        this.beak = root.m_171324_("beak");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(17, 1).m_171488_(-3.0f, -4.0f, -4.0f, 6.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(18, 18).m_171488_(0.0f, -2.0f, 4.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -9.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(1, 30).m_171488_(-2.0f, -5.0f, -10.0f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(1, 22).m_171488_(-2.0f, -6.0f, -10.0f, 4.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        PartDefinition leg0 = modelPartData.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(6, 45).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)1.0f));
        PartDefinition leg1 = modelPartData.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(6, 45).m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)19.0f, (float)1.0f));
        PartDefinition wing0 = modelPartData.m_171599_("wing0", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(-1.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        PartDefinition wing1 = modelPartData.m_171599_("wing1", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(0.0f, -1.0f, -3.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        PartDefinition beak = modelPartData.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.0f, -7.0f, -6.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.head.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.leg0.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.leg1.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.wing0.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.wing1.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        this.beak.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.beak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leg0, (Object)this.leg1, (Object)this.wing0, (Object)this.wing1);
    }

    public void m_6973_(T entity, float f, float g, float h, float i, float j) {
        this.head.f_104203_ = j * ((float)Math.PI / 180);
        this.head.f_104204_ = i * ((float)Math.PI / 180);
        this.beak.f_104203_ = this.head.f_104203_;
        this.beak.f_104204_ = this.head.f_104204_;
        this.leg0.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        this.leg1.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.wing0.f_104205_ = h;
        this.wing1.f_104205_ = -h;
    }
}

