/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import satisfy.bloomingnature.entity.RaccoonEntity;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

@OnlyIn(value=Dist.CLIENT)
public class RaccoonModel<T extends RaccoonEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new BloomingNatureIdentifier("raccoon"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart tail;
    private float legMotionPos;

    public RaccoonModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leftHindLeg = root.m_171324_("leftHindLeg");
        this.rightHindLeg = root.m_171324_("rightHindLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-4.0f, -3.0f, -5.0f, 8.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -1.0f, -6.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 13).m_171488_(-4.0f, -3.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -3.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 13).m_171488_(-2.0f, 3.0f, -9.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-3.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(8, 30).m_171488_(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)6.0f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)6.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(8, 30).m_171488_(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)-1.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)-1.0f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(-3.0f, 1.0f, -4.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T raccoon, float f, float g, float h) {
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        this.rightHindLeg.f_104207_ = true;
        this.leftHindLeg.f_104207_ = true;
        this.rightFrontLeg.f_104207_ = true;
        this.leftFrontLeg.f_104207_ = true;
        if (((RaccoonEntity)((Object)raccoon)).m_5803_()) {
            this.body.f_104205_ = -1.5707964f;
            this.body.m_104227_(0.0f, 21.0f, -6.0f);
            this.tail.f_104203_ = -2.6179938f;
            if (this.f_102610_) {
                this.tail.f_104203_ = -2.1816616f;
                this.body.m_104227_(0.0f, 21.0f, -2.0f);
            }
            this.head.m_104227_(1.0f, 19.49f, -3.0f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = 0.0f;
            this.rightHindLeg.f_104207_ = false;
            this.leftHindLeg.f_104207_ = false;
            this.rightFrontLeg.f_104207_ = false;
            this.leftFrontLeg.f_104207_ = false;
        }
    }

    public void setupAnim(T raccoon, float f, float g, float h, float i, float j) {
        if (!(((RaccoonEntity)((Object)raccoon)).m_5803_() || ((RaccoonEntity)((Object)raccoon)).isFaceplanted() || raccoon.m_6047_())) {
            this.head.f_104203_ = j * ((float)Math.PI / 180);
            this.head.f_104204_ = i * ((float)Math.PI / 180);
            this.tail.f_104203_ = h;
            this.tail.f_104204_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
            this.tail.m_104227_(0.0f, 18.0f, 7.0f);
        }
        if (((RaccoonEntity)((Object)raccoon)).m_5803_()) {
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = -2.0943952f;
            this.head.f_104205_ = Mth.m_14089_((float)(h * 0.027f)) / 22.0f;
        }
        if (raccoon.m_6047_()) {
            float k;
            this.body.f_104204_ = k = Mth.m_14089_((float)h) * 0.01f;
            this.rightHindLeg.f_104205_ = k;
            this.leftHindLeg.f_104205_ = k;
            this.rightFrontLeg.f_104205_ = k / 2.0f;
            this.leftFrontLeg.f_104205_ = k / 2.0f;
        }
        if (((RaccoonEntity)((Object)raccoon)).isFaceplanted()) {
            this.legMotionPos += 0.67f;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f)) * 0.1f;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f + (float)Math.PI)) * 0.1f;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f + (float)Math.PI)) * 0.1f;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(this.legMotionPos * 0.4662f)) * 0.1f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.body;
    }
}

