/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

@OnlyIn(value=Dist.CLIENT)
public class RedWolfModel<T extends Wolf>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new BloomingNatureIdentifier("red_wolf"), "main");
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;

    public RedWolfModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.upperBody = root.m_171324_("upperBody");
        this.leftHindLeg = root.m_171324_("leftHindLeg");
        this.rightHindLeg = root.m_171324_("rightHindLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.tail = root.m_171324_("tail");
        this.realTail = this.tail.m_171324_(REAL_TAIL);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.0f, -3.0f, -4.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171488_(-3.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 27).m_171488_(-1.0f, 0.0f, -7.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -7.0f, -5.0f, 6.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperBody = partdefinition.m_171599_("upperBody", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(26, 33).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(26, 33).m_171488_(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.01f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-1.0f, 0.0f, -4.25f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(23, 17).m_171488_(-1.0f, 9.0f, -4.25f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition real_tail = tail.m_171599_(REAL_TAIL, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)12.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.upperBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.body;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T wolf, float f, float g, float h) {
        this.tail.f_104204_ = wolf.m_21660_() ? 0.0f : Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        if (wolf.m_21825_()) {
            this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
            this.upperBody.f_104203_ = 1.2566371f;
            this.upperBody.f_104204_ = 0.0f;
            this.body.m_104227_(0.0f, 18.0f, 0.0f);
            this.body.f_104203_ = 0.7853982f;
            this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.m_104227_(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.f_104203_ = 4.712389f;
            this.leftHindLeg.m_104227_(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.f_104203_ = 4.712389f;
            this.rightFrontLeg.f_104203_ = 5.811947f;
            this.rightFrontLeg.m_104227_(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.f_104203_ = 5.811947f;
            this.leftFrontLeg.m_104227_(0.51f, 17.0f, -4.0f);
        } else {
            this.body.m_104227_(0.0f, 14.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        }
        this.head.f_104205_ = wolf.m_30448_(h) + wolf.m_30432_(h, 0.0f);
        this.upperBody.f_104205_ = wolf.m_30432_(h, -0.08f);
        this.body.f_104205_ = wolf.m_30432_(h, -0.16f);
        this.realTail.f_104205_ = wolf.m_30432_(h, -0.2f);
    }

    public void setupAnim(T wolf, float f, float g, float h, float i, float j) {
        this.head.f_104203_ = j * ((float)Math.PI / 180);
        this.head.f_104204_ = i * ((float)Math.PI / 180);
        this.tail.f_104203_ = h;
    }
}

