/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MossySheepWoolFeature<T extends Sheep, F extends SheepModel<T>>
extends RenderLayer<T, F> {
    private final SheepFurModel<T> model;
    private final String name;

    public MossySheepWoolFeature(RenderLayerParent<T, F> context, EntityModelSet loader, String name, ModelLayerLocation sheepWoolModel) {
        super(context);
        this.model = new SheepFurModel(loader.m_171103_(sheepWoolModel));
        this.name = name;
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T sheepEntity, float f, float g, float h, float j, float k, float l) {
        float u;
        float t;
        float s;
        ResourceLocation skin = this.name.equals("DEFAULT") ? new ResourceLocation("textures/entity/sheep_fur.png") : new ResourceLocation("bloomingnature", "textures/entity/" + this.name + "_sheep_fur.png");
        if (sheepEntity.m_29875_()) {
            return;
        }
        if (sheepEntity.m_20145_()) {
            Minecraft minecraftClient = Minecraft.m_91087_();
            boolean bl = minecraftClient.m_91314_(sheepEntity);
            if (bl) {
                ((SheepModel)this.m_117386_()).m_102624_(this.model);
                this.model.m_6839_(sheepEntity, f, g, h);
                this.model.m_6973_(sheepEntity, f, g, j, k, l);
                VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110491_((ResourceLocation)skin));
                this.model.m_7695_(matrixStack, vertexConsumer, i, LivingEntityRenderer.m_115338_(sheepEntity, (float)0.0f), 0.0f, 0.0f, 0.0f, 1.0f);
            }
            return;
        }
        if (sheepEntity.m_8077_() && "jeb_".equals(sheepEntity.m_7755_().getString())) {
            int n = ((Sheep)sheepEntity).f_19797_ / 25 + sheepEntity.m_19879_();
            int o = DyeColor.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = ((float)(((Sheep)sheepEntity).f_19797_ % 25) + h) / 25.0f;
            float[] fs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)p));
            float[] gs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)q));
            s = fs[0] * (1.0f - r) + gs[0] * r;
            t = fs[1] * (1.0f - r) + gs[1] * r;
            u = fs[2] * (1.0f - r) + gs[2] * r;
        } else {
            float[] hs = Sheep.m_29829_((DyeColor)sheepEntity.m_29874_());
            s = hs[0];
            t = hs[1];
            u = hs[2];
        }
        MossySheepWoolFeature.m_117359_((EntityModel)this.m_117386_(), this.model, (ResourceLocation)skin, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumerProvider, (int)i, sheepEntity, (float)f, (float)g, (float)j, (float)k, (float)l, (float)h, (float)s, (float)t, (float)u);
    }
}

