/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.entity;

import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import satisfy.bloomingnature.registry.EntityRegistry;
import satisfy.bloomingnature.registry.SoundRegistry;

public class BisonEntity
extends Animal
implements NeutralMob {
    private boolean isAngry;
    private long lastHurtTime;
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_RANGE = TimeUtil.m_145020_((int)15, (int)34);
    private UUID lastHurtBy;

    public BisonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BisonPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(9, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::m_21674_));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)EntityRegistry.BISON.get()).m_20615_((Level)pLevel);
    }

    protected SoundEvent m_7515_() {
        return this.m_21660_() ? (SoundEvent)SoundRegistry.BISON_ANGRY.get() : (SoundEvent)SoundRegistry.BISON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.BISON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.BISON_DEATH.get();
    }

    public int m_8085_() {
        return 35;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_RANGE.m_214085_(this.f_19796_));
    }

    public boolean m_21674_(LivingEntity entity) {
        return entity instanceof Player && this.isAngry && this.shouldBeAngry();
    }

    private boolean shouldBeAngry() {
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.25) {
            return false;
        }
        return this.m_20193_().m_46467_() - this.lastHurtTime < 300L;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22283_, 1.25).m_22268_(Attributes.f_22279_, 0.18000099062919617).m_22268_(Attributes.f_22285_, 0.01777747832238674).m_22268_(Attributes.f_22282_, 2.0);
    }

    static class BisonPanicGoal
    extends PanicGoal {
        public BisonPanicGoal(BisonEntity bison) {
            super((PathfinderMob)bison, 1.2);
        }

        public boolean m_8036_() {
            return this.f_25684_.m_6162_() && super.m_8036_();
        }
    }
}

