/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.entity;

import java.util.Iterator;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import satisfy.bloomingnature.entity.ai.FlyingFollowOwnerGoal;
import satisfy.bloomingnature.entity.ai.PredicateTemptGoal;
import satisfy.bloomingnature.registry.EntityRegistry;
import satisfy.bloomingnature.registry.SoundRegistry;
import satisfy.bloomingnature.registry.TagsRegistry;

public class OwlEntity
extends ShoulderRidingEntity {
    private static final EntityDataAccessor<Integer> STANDING_STATE = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OWL_STATE = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions FLYING_DIMENSION = new EntityDimensions(0.7f, 1.4f, false);
    private static final Predicate<LivingEntity> IS_OWL_TARGET = e -> e.m_6095_().m_204039_(TagsRegistry.OWL_TARGETS);
    private float leaningPitch;
    private float lastLeaningPitch;

    public OwlEntity(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 0, false);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
    }

    public static boolean checkSpawnRules(EntityType<OwlEntity> owlEntityEntityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return (state.m_60713_(Blocks.f_50440_) || state.m_204336_(BlockTags.f_13035_)) && level.m_45524_(pos, 0) > 2;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, 0.8).m_22268_(Attributes.f_22276_, 9.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FlyingFollowOwnerGoal((TamableAnimal)this, 1.2, 10.0f, 2.0f, true));
        this.f_21345_.m_25352_(5, (Goal)new PredicateTemptGoal((PathfinderMob)this, 1.2, this::m_6898_, false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new ExtendedFlyOntoTree((PathfinderMob)this, 1.0, 0.5f));
        this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, IS_OWL_TARGET));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OwlEntity owl = (OwlEntity)((EntityType)EntityRegistry.OWL.get()).m_20615_((Level)serverLevel);
        UUID uUID = this.m_21805_();
        if (uUID != null) {
            owl.m_21816_(uUID);
            owl.m_7105_(true);
        }
        return owl;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level);
        birdNavigation.m_26443_(true);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(false);
        return birdNavigation;
    }

    public float m_20998_(float f) {
        return Mth.m_14189_((float)f, (float)this.lastLeaningPitch, (float)this.leaningPitch);
    }

    public void m_8119_() {
        super.m_8119_();
        this.setStandingState(this.m_20096_() || this.m_20069_() || this.m_21827_() ? StandingState.STANDING : StandingState.FLYING);
        this.lastLeaningPitch = this.leaningPitch;
        switch (this.getStandingState()) {
            case STANDING: {
                this.leaningPitch = Math.max(0.0f, this.leaningPitch - 2.0f);
                break;
            }
            case FLYING: {
                this.leaningPitch = Math.min(7.0f, this.leaningPitch + 1.5f);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 velocity = this.m_20184_();
        if (!this.m_20096_() && velocity.f_82480_ < 0.0) {
            this.m_20256_(velocity.m_82542_(1.0, 0.75, 1.0));
        }
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.m_21824_()) {
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                if (!this.m_9236_().m_5776_()) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    this.m_5634_(item.m_41473_().m_38744_());
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult actionResult = super.m_6071_(player, hand);
            if ((!actionResult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                }
                return InteractionResult.SUCCESS;
            }
            return actionResult;
        }
        if (this.m_6898_(stack) && this.m_5448_() == null) {
            if (!this.m_9236_().m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        Item item = stack.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("OwlState", ((Integer)this.m_20088_().m_135370_(OWL_STATE)).intValue());
        tag.m_128405_("StandingState", ((Integer)this.m_20088_().m_135370_(STANDING_STATE)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setOwlState(OwlState.values()[tag.m_128451_("OwlState")]);
        this.setStandingState(StandingState.values()[tag.m_128451_("StandingState")]);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.getStandingState() == StandingState.STANDING ? super.m_6972_(pose) : FLYING_DIMENSION;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(STANDING_STATE, (Object)0);
        this.m_20088_().m_135372_(OWL_STATE, (Object)0);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public void setOwlState(OwlState owlState) {
        this.m_20088_().m_135381_(OWL_STATE, (Object)owlState.ordinal());
    }

    public void setStandingState(StandingState standingState) {
        this.m_20088_().m_135381_(STANDING_STATE, (Object)standingState.ordinal());
    }

    public StandingState getStandingState() {
        return StandingState.values()[(Integer)this.m_20088_().m_135370_(STANDING_STATE)];
    }

    public OwlState getOwlState() {
        return OwlState.values()[(Integer)this.m_20088_().m_135370_(OWL_STATE)];
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.OWL_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.OWL_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.OWL_HURT.get();
    }

    private static class ExtendedFlyOntoTree
    extends WaterAvoidingRandomStrollGoal {
        public ExtendedFlyOntoTree(PathfinderMob pathAwareEntity, double speed, float probability) {
            super(pathAwareEntity, speed, probability);
        }

        protected Vec3 m_7037_() {
            Vec3 vec3d = null;
            if (this.f_25725_.m_20072_()) {
                vec3d = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
            }
            if (this.f_25725_.m_217043_().m_188501_() >= this.f_25985_) {
                vec3d = this.getTreeTarget();
            }
            return vec3d == null ? super.m_7037_() : vec3d;
        }

        private Vec3 getTreeTarget() {
            BlockState blockState;
            boolean bl;
            BlockPos blockPos2;
            BlockPos blockPos = this.f_25725_.m_20097_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
            Iterable iterable = BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)));
            Iterator var5 = iterable.iterator();
            do {
                if (var5.hasNext()) continue;
                return null;
            } while (blockPos.equals((Object)(blockPos2 = (BlockPos)var5.next())) || !(bl = (blockState = this.f_25725_.m_9236_().m_8055_((BlockPos)mutable2.m_122159_((Vec3i)blockPos2, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockState.m_204336_(BlockTags.f_13106_)) || !this.f_25725_.m_9236_().m_46859_(blockPos2) || !this.f_25725_.m_9236_().m_46859_((BlockPos)mutable.m_122159_((Vec3i)blockPos2, Direction.UP)));
            return Vec3.m_82539_((Vec3i)blockPos2);
        }
    }

    public static enum StandingState {
        STANDING,
        FLYING;

    }

    public static enum OwlState {
        IDLE,
        ATTACKING;

    }
}

