/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.entity;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.bloomingnature.registry.EntityRegistry;
import satisfy.bloomingnature.registry.SoundRegistry;

public class RaccoonEntity
extends Animal {
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID;
    private static final int FLAG_SITTING = 1;
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final int FLAG_SLEEPING = 32;
    private static final int FLAG_FACEPLANTED = 64;
    private static final int FLAG_DEFENDING = 128;
    private int ticksSinceEaten;

    public RaccoonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.20000001192092895).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.5);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.ticksSinceEaten;
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.m_6898_(itemStack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemStack2 = itemStack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemStack2.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemStack2);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemStack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
        if (this.isDefending() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
        }
    }

    public float getTailAngle() {
        return (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.4f : entityDimensions.f_20378_ * 0.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.RACCOON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.RACCOON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.RACCOON_DEATH.get();
    }

    @Nullable
    public RaccoonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (RaccoonEntity)((EntityType)EntityRegistry.RACCOON.get()).m_20615_((Level)serverLevel);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i)));
        }
    }

    private boolean getFlag(int i) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & i) != 0;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    static {
        DATA_TYPE_ID = SynchedEntityData.m_135353_(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_FLAGS_ID = SynchedEntityData.m_135353_(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42780_, Items.f_42620_, Items.f_42530_, Items.f_42531_, Items.f_42619_});
    }
}

