/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import satisfy.bloomingnature.registry.EntityRegistry;

public class SheepEntity
extends Sheep {
    private final Block woolBlock;
    private final ResourceLocation lootTable;
    private final Map<DyeColor, ItemLike> DROPS = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.ORANGE, Blocks.f_50042_);
        map.put(DyeColor.MAGENTA, Blocks.f_50096_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        map.put(DyeColor.YELLOW, Blocks.f_50098_);
        map.put(DyeColor.LIME, Blocks.f_50099_);
        map.put(DyeColor.PINK, Blocks.f_50100_);
        map.put(DyeColor.GRAY, Blocks.f_50101_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        map.put(DyeColor.CYAN, Blocks.f_50103_);
        map.put(DyeColor.PURPLE, Blocks.f_50104_);
        map.put(DyeColor.BLUE, Blocks.f_50105_);
        map.put(DyeColor.BROWN, Blocks.f_50106_);
        map.put(DyeColor.GREEN, Blocks.f_50107_);
        map.put(DyeColor.RED, Blocks.f_50108_);
        map.put(DyeColor.BLACK, Blocks.f_50109_);
    });

    public SheepEntity(EntityType<? extends Sheep> entityType, Level world, Block woolBlock, ResourceLocation lootTable) {
        super(entityType, world);
        this.woolBlock = woolBlock;
        this.lootTable = lootTable;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 9.0).m_22268_(Attributes.f_22279_, (double)0.23f);
    }

    public Sheep m_142606_(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (Sheep)((EntityType)EntityRegistry.MOSSY_SHEEP.get()).m_20615_((Level)serverWorld);
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        if (!this.DROPS.containsValue(this.woolBlock)) {
            this.DROPS.put(DyeColor.WHITE, (ItemLike)this.woolBlock);
        }
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        this.m_29878_(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_20000_(this.DROPS.get(this.m_29874_()), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return this.m_6095_().m_20677_();
        }
        switch (this.m_29874_()) {
            default: {
                return this.lootTable;
            }
            case ORANGE: {
                return BuiltInLootTables.f_78703_;
            }
            case MAGENTA: {
                return BuiltInLootTables.f_78704_;
            }
            case LIGHT_BLUE: {
                return BuiltInLootTables.f_78705_;
            }
            case YELLOW: {
                return BuiltInLootTables.f_78706_;
            }
            case LIME: {
                return BuiltInLootTables.f_78707_;
            }
            case PINK: {
                return BuiltInLootTables.f_78708_;
            }
            case GRAY: {
                return BuiltInLootTables.f_78709_;
            }
            case LIGHT_GRAY: {
                return BuiltInLootTables.f_78710_;
            }
            case CYAN: {
                return BuiltInLootTables.f_78711_;
            }
            case PURPLE: {
                return BuiltInLootTables.f_78714_;
            }
            case BLUE: {
                return BuiltInLootTables.f_78715_;
            }
            case BROWN: {
                return BuiltInLootTables.f_78716_;
            }
            case GREEN: {
                return BuiltInLootTables.f_78717_;
            }
            case RED: {
                return BuiltInLootTables.f_78718_;
            }
            case BLACK: 
        }
        return BuiltInLootTables.f_78719_;
    }
}

