/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.forge.world;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import satisfy.bloomingnature.forge.registry.BloomingNatureBiomeModifiers;
import satisfy.bloomingnature.registry.EntityRegistry;
import satisfy.bloomingnature.registry.TagsRegistry;

public class AddAnimalsBiomeModifier
implements BiomeModifier {
    private static final Set<EntityType<?>> registeredEntities = new HashSet();

    private static <T extends Mob> void registerEntity(EntityType<T> type, SpawnPlacements.Type spawnType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (!registeredEntities.contains(type)) {
            SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)spawnType, (Heightmap.Types)heightmapType, predicate);
            registeredEntities.add(type);
        }
    }

    public static void registerEntities() {
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.SQUIRREL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.TERMITE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.OWL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.TURKEY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.RACCOON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.PELICAN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.MUDDY_PIG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.DEER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.MOSSY_SHEEP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.RED_WOLF.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.BOAR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityRegistry.BISON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase.equals((Object)BiomeModifier.Phase.ADD)) {
            AddAnimalsBiomeModifier.registerEntities();
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DEER, MobCategory.CREATURE, (EntityType)EntityRegistry.DEER.get(), 12, 2, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DEER, MobCategory.CREATURE, (EntityType)EntityRegistry.DEER.get(), 12, 2, 4);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207604_, MobCategory.CREATURE, (EntityType)EntityRegistry.PELICAN.get(), 5, 3, 4);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207595_, MobCategory.CREATURE, EntityType.f_20568_, 4, 1, 2);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207595_, MobCategory.CREATURE, EntityType.f_20493_, 4, 1, 2);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207595_, MobCategory.CREATURE, EntityType.f_20513_, 4, 1, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_MUDDY_PIG, MobCategory.CREATURE, (EntityType)EntityRegistry.MUDDY_PIG.get(), 8, 4, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_MOSSY_SHEEP, MobCategory.CREATURE, (EntityType)EntityRegistry.MOSSY_SHEEP.get(), 8, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RACCOON, MobCategory.CREATURE, (EntityType)EntityRegistry.RACCOON.get(), 8, 2, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_SQUIRREL, MobCategory.CREATURE, (EntityType)EntityRegistry.SQUIRREL.get(), 8, 2, 2);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RED_WOLF, MobCategory.CREATURE, (EntityType)EntityRegistry.RED_WOLF.get(), 10, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_OWL, MobCategory.CREATURE, (EntityType)EntityRegistry.OWL.get(), 12, 3, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BOAR, MobCategory.CREATURE, (EntityType)EntityRegistry.BOAR.get(), 14, 5, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BISON, MobCategory.CREATURE, (EntityType)EntityRegistry.BISON.get(), 10, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_TURKEY, MobCategory.CREATURE, (EntityType)EntityRegistry.TURKEY.get(), 12, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_TURKEY, MobCategory.CREATURE, (EntityType)EntityRegistry.TURKEY.get(), 12, 3, 5);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_207610_, MobCategory.CREATURE, EntityType.f_217012_, 8, 3, 4);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.f_215816_, MobCategory.CREATURE, (EntityType)EntityRegistry.TERMITE.get(), 10, 3, 4);
        }
    }

    void addMobSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, TagKey<Biome> tag, MobCategory mobCategory, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (biome.m_203656_(tag)) {
            builder.getMobSpawnSettings().m_48376_(mobCategory, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BloomingNatureBiomeModifiers.ADD_ANIMALS_CODEC.get();
    }
}

