/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import satisfy.bloomingnature.BloomingNature;
import satisfy.bloomingnature.entity.BisonEntity;
import satisfy.bloomingnature.entity.BoarEntity;
import satisfy.bloomingnature.entity.DeerEntity;
import satisfy.bloomingnature.entity.MossySheepEntity;
import satisfy.bloomingnature.entity.MuddyPigEntity;
import satisfy.bloomingnature.entity.OwlEntity;
import satisfy.bloomingnature.entity.PelicanEntity;
import satisfy.bloomingnature.entity.RaccoonEntity;
import satisfy.bloomingnature.entity.RedWolfEntity;
import satisfy.bloomingnature.entity.SheepEntity;
import satisfy.bloomingnature.entity.SquirrelEntity;
import satisfy.bloomingnature.entity.TermiteEntity;
import satisfy.bloomingnature.entity.TurkeyEntity;
import satisfy.bloomingnature.entity.WanderingGardenerEntity;
import satisfy.bloomingnature.util.BloomingNatureIdentifier;

public class EntityRegistry {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<WanderingGardenerEntity>> WANDERING_GARDENER = EntityRegistry.create("wandering_gardener", () -> EntityType.Builder.m_20704_(WanderingGardenerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(new BloomingNatureIdentifier("wandering_gardener").toString()));
    public static final RegistrySupplier<EntityType<RedWolfEntity>> RED_WOLF = EntityRegistry.create("red_wolf", () -> EntityType.Builder.m_20704_(RedWolfEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 1.5f).m_20702_(10).m_20712_(new BloomingNatureIdentifier("red_wolf").toString()));
    public static final RegistrySupplier<EntityType<PelicanEntity>> PELICAN = EntityRegistry.create("pelican", () -> EntityType.Builder.m_20704_(PelicanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BloomingNatureIdentifier("pelican").toString()));
    public static final RegistrySupplier<EntityType<RaccoonEntity>> RACCOON = EntityRegistry.create("raccoon", () -> EntityType.Builder.m_20704_(RaccoonEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BloomingNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<EntityType<MossySheepEntity>> MOSSY_SHEEP = EntityRegistry.create("mossy_sheep", () -> EntityType.Builder.m_20704_(MossySheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("bloomingnature", "mossy_sheep").toString()));
    public static final RegistrySupplier<EntityType<SquirrelEntity>> SQUIRREL = EntityRegistry.create("squirrel", () -> EntityType.Builder.m_20704_(SquirrelEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BloomingNatureIdentifier("raccoon").toString()));
    public static final RegistrySupplier<EntityType<MuddyPigEntity>> MUDDY_PIG = EntityRegistry.create("muddy_pig", () -> EntityType.Builder.m_20704_(MuddyPigEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BloomingNatureIdentifier("muddy_pig").toString()));
    public static final RegistrySupplier<EntityType<TurkeyEntity>> TURKEY = EntityRegistry.create("turkey", () -> EntityType.Builder.m_20704_(TurkeyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BloomingNatureIdentifier("turkey").toString()));
    public static final RegistrySupplier<EntityType<DeerEntity>> DEER = EntityRegistry.create("deer", () -> EntityType.Builder.m_20704_(DeerEntity::new, (MobCategory)MobCategory.CREATURE).m_20712_(new BloomingNatureIdentifier("deer").toString()));
    public static final RegistrySupplier<EntityType<OwlEntity>> OWL = EntityRegistry.create("owl", () -> EntityType.Builder.m_20704_(OwlEntity::new, (MobCategory)MobCategory.CREATURE).m_20712_(new BloomingNatureIdentifier("owl").toString()));
    public static final RegistrySupplier<EntityType<TermiteEntity>> TERMITE = EntityRegistry.create("termite", () -> EntityType.Builder.m_20704_(TermiteEntity::new, (MobCategory)MobCategory.MONSTER).m_20712_(new BloomingNatureIdentifier("termite").toString()));
    public static final RegistrySupplier<EntityType<BoarEntity>> BOAR = EntityRegistry.create("boar", () -> EntityType.Builder.m_20704_(BoarEntity::new, (MobCategory)MobCategory.CREATURE).m_20712_(new BloomingNatureIdentifier("boar").toString()));
    public static final RegistrySupplier<EntityType<BisonEntity>> BISON = EntityRegistry.create("bison", () -> EntityType.Builder.m_20704_(BisonEntity::new, (MobCategory)MobCategory.CREATURE).m_20712_(new BloomingNatureIdentifier("bison").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BloomingNatureIdentifier(path), type);
    }

    public static void init() {
        BloomingNature.LOGGER.debug("Registering Entities for bloomingnature");
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(WANDERING_GARDENER, Mob::m_21552_);
        EntityAttributeRegistry.register(MOSSY_SHEEP, SheepEntity::createMobAttributes);
        EntityAttributeRegistry.register(DEER, DeerEntity::createMobAttributes);
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createMobAttributes);
        EntityAttributeRegistry.register(RED_WOLF, RedWolfEntity::createMobAttributes);
        EntityAttributeRegistry.register(RACCOON, RaccoonEntity::createMobAttributes);
        EntityAttributeRegistry.register(SQUIRREL, SquirrelEntity::createMobAttributes);
        EntityAttributeRegistry.register(MUDDY_PIG, MuddyPigEntity::createMobAttributes);
        EntityAttributeRegistry.register(OWL, OwlEntity::createMobAttributes);
        EntityAttributeRegistry.register(BOAR, BoarEntity::createMobAttributes);
        EntityAttributeRegistry.register(TERMITE, TermiteEntity::createMobAttributes);
        EntityAttributeRegistry.register(BISON, BisonEntity::createMobAttributes);
        EntityAttributeRegistry.register(TURKEY, TurkeyEntity::createMobAttributes);
    }
}

