/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bloomingnature.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import satisfy.bloomingnature.registry.PlacerTypesRegistry;

public class RodBirchFoliagePlacer
extends FoliagePlacer {
    protected final int height;
    protected final float offsetChance;
    public static final Codec<RodBirchFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> RodBirchFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(cdc -> cdc.height)).and((App)Codec.FLOAT.fieldOf("offset_chance").forGetter(cdc -> Float.valueOf(cdc.offsetChance))).apply((Applicative)instance, RodBirchFoliagePlacer::new));

    public RodBirchFoliagePlacer(IntProvider radius, IntProvider offset, int height, float offsetChance) {
        super(radius, offset);
        this.height = height;
        this.offsetChance = offsetChance;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.ROD_BIRCH_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foligateSetter, RandomSource random, TreeConfiguration treeConfiguration, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        BoundingBox box = new BoundingBox(attachment.m_161451_());
        int offsetValue = this.f_68521_.m_214085_(random);
        int radiusValue = this.f_68520_.m_214085_(random);
        for (int placeOffset = offsetValue; placeOffset >= offsetValue - foliageHeight; --placeOffset) {
            int baseHeight = attachment.m_68589_() > 0 ? Math.max(radiusValue + attachment.m_68589_() - 1 - placeOffset / 2, 0) : Math.max(radiusValue + attachment.m_68589_() - placeOffset / 2, 0);
            this.placeLeavesRow(level, foligateSetter, random, treeConfiguration, attachment.m_161451_(), baseHeight, placeOffset, attachment.m_68590_(), box);
        }
    }

    protected void placeLeavesRow(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos blockPos, int radius, int yy, boolean isBig, BoundingBox box) {
        int offset = isBig ? 1 : 0;
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int xx = -radius; xx <= radius + offset; ++xx) {
            for (int zz = -radius; zz <= radius + offset; ++zz) {
                if (this.m_214202_(random, xx, yy, zz, radius, isBig)) continue;
                placePos.m_122154_((Vec3i)blockPos, xx, yy, zz);
                this.placeLeaf(level, foliageSetter, random, treeConfiguration, (BlockPos)placePos, box);
                if (!(random.m_188501_() < this.offsetChance)) continue;
                Direction offsetDir = Direction.m_235672_((RandomSource)random);
                this.placeLeaf(level, foliageSetter, random, treeConfiguration, placePos.m_121945_(offsetDir), box);
            }
        }
    }

    protected void placeLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration configuration, BlockPos placePos, BoundingBox box) {
        FoliagePlacer.m_272253_((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)configuration, (BlockPos)placePos);
        box.m_162371_(new BlockPos((Vec3i)placePos));
    }

    public int m_214116_(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource random, int baseHeight, int dx, int dy, int dz, boolean giantTrunk) {
        if (baseHeight + dy >= 4) {
            return true;
        }
        return baseHeight * baseHeight + dy * dy > dz * dz;
    }
}

