/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.events;

import com.Apothic0n.Astrological.api.AstrologicalJsonReader;
import com.Apothic0n.Astrological.api.effect.AstrologicalMobEffects;
import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="astrological", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level.f_46443_ || player.m_5833_() || player.m_146899_())) {
            Block sleep;
            boolean underVoid = false;
            BlockPos blockPos = player.m_20183_();
            BlockState standingOn = player.m_20075_();
            if (standingOn.m_60713_(sleep = (Block)AstrologicalBlocks.SLEEP.get()) || level.m_8055_(blockPos).m_60713_(sleep)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 60, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 2, 0));
            }
            if (level.m_8055_(blockPos.m_175288_((int)player.m_146892_().f_82480_)).m_60713_(sleep)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 2, 1));
            }
            if (standingOn.m_60713_((Block)AstrologicalBlocks.OCHRE_SELENITE.get())) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 31));
            } else if (standingOn.m_60713_((Block)AstrologicalBlocks.VERDANT_SELENITE.get())) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 5, 9));
            } else if (standingOn.m_60713_((Block)AstrologicalBlocks.PEARLESCENT_SELENITE.get())) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 150, 0));
            } else if (standingOn.m_60713_((Block)AstrologicalBlocks.PRISMATIC_SELENITE.get()) || standingOn.m_60713_((Block)AstrologicalBlocks.SELENITE_WALL.get())) {
                float time = level.m_46468_();
                if (time > 24000.0f) {
                    time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
                }
                if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 31));
                } else if (time <= 12000.0f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 5, 9));
                } else {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 150, 0));
                }
            }
            List<BlockPos> neighboring = List.of(blockPos.m_7495_(), blockPos, blockPos.m_7494_(), blockPos.m_122012_(), blockPos.m_7494_().m_122012_(), blockPos.m_122029_(), blockPos.m_7494_().m_122029_(), blockPos.m_122019_(), blockPos.m_7494_().m_122019_(), blockPos.m_122024_(), blockPos.m_7494_().m_122024_());
            for (int i = 0; i < neighboring.size(); ++i) {
                BlockState blockState = level.m_8055_(neighboring.get(i));
                if (!blockState.m_60713_((Block)AstrologicalBlocks.TENDRILS.get()) && !blockState.m_60713_((Block)AstrologicalBlocks.TUMOR.get()) || player.m_21023_(MobEffects.f_19604_)) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 120, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 1));
                player.m_7292_(new MobEffectInstance((MobEffect)AstrologicalMobEffects.ENDFECTED.get(), 80, 1));
                CommonEvents.teleportPlayer(level, player);
            }
            if (player.m_21023_((MobEffect)AstrologicalMobEffects.ENDFECTED.get())) {
                if ((int)(Math.random() * 240.0 + 1.0) < 2 || player.m_21124_((MobEffect)AstrologicalMobEffects.ENDFECTED.get()).m_267633_(3) && (int)(Math.random() * 20.0 + 1.0) < 2) {
                    CommonEvents.teleportPlayer(level, player);
                } else {
                    CommonEvents.spreadEndfection(level, player.m_20097_(), false);
                    CommonEvents.spreadEndfection(level, player.m_20097_().m_122012_(), true);
                    CommonEvents.spreadEndfection(level, player.m_20097_().m_122029_(), true);
                    CommonEvents.spreadEndfection(level, player.m_20097_().m_122019_(), true);
                    CommonEvents.spreadEndfection(level, player.m_20097_().m_122024_(), true);
                }
            }
            if (level.m_46472_().equals((Object)Level.f_46430_)) {
                float time = level.m_46468_();
                if ((time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0)) >= 22750.0f && time <= 23750.0f || time >= 12500.0f && time <= 13000.0f) {
                    int playerY = player.m_20183_().m_123342_();
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(player.m_20183_().m_123341_(), playerY, player.m_20183_().m_123343_());
                    int maxHeight = level.m_151558_();
                    boolean underVoidYet = true;
                    for (int y = playerY; y < maxHeight; ++y) {
                        if (level.m_8055_((BlockPos)mutableBlockPos.m_142448_(y)).m_60795_()) continue;
                        underVoidYet = false;
                        break;
                    }
                    underVoid = underVoidYet;
                }
            }
            if (underVoid && AstrologicalJsonReader.weatherBasedLevitationEffects) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20, 5));
                if (player.m_20159_()) {
                    Objects.requireNonNull(player.m_20202_()).m_246865_(new Vec3(0.0, 0.2, 0.0));
                }
            }
        }
    }

    private static void teleportPlayer(Level level, Player player) {
        double d0 = player.m_20185_();
        double d1 = player.m_20186_();
        double d2 = player.m_20189_();
        for (int i = 0; i < 16; ++i) {
            double d3 = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            double d4 = Mth.m_14008_((double)(player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + ((ServerLevel)level).m_143344_() - 1));
            double d5 = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            if (player.m_20159_()) {
                player.m_8127_();
            }
            Vec3 vec3 = player.m_20182_();
            level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)player));
            if (!player.m_20984_(player.m_20185_() + (Math.random() * 32.0 - 16.0), player.m_20186_() + 16.0, player.m_20189_() + (Math.random() * 32.0 - 16.0), true)) continue;
            SoundEvent soundevent = SoundEvents.f_11757_;
            level.m_6263_(null, d0, d1, d2, soundevent, SoundSource.PLAYERS, 1.0f, 0.75f);
            player.m_5496_(soundevent, 1.0f, 0.75f);
            break;
        }
    }

    private static void spreadEndfection(Level level, BlockPos blockPos, boolean hasTumor) {
        if ((int)(Math.random() * 4.0 + 1.0) < 2) {
            CommonEvents.replaceEndstone(level, blockPos, ((Block)AstrologicalBlocks.TUMOR.get()).m_49966_());
            if (Math.random() * 10.0 + 1.0 < 2.0) {
                SoundEvent soundevent = SoundEvents.f_215753_;
                level.m_6263_((Player)null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), soundevent, SoundSource.PLAYERS, 10.0f, 0.75f);
            }
            if (hasTumor && (int)(Math.random() * 5.0 + 1.0) < 2) {
                CommonEvents.placeOnCyst(level, blockPos.m_7494_(), ((Block)AstrologicalBlocks.TENDRILS.get()).m_49966_());
                if ((int)(Math.random() * 5.0 + 1.0) < 2) {
                    CommonEvents.placeOnCyst(level, blockPos.m_6630_(2), ((Block)AstrologicalBlocks.TENDRILS.get()).m_49966_());
                    if ((int)(Math.random() * 5.0 + 1.0) < 2) {
                        CommonEvents.placeOnCyst(level, blockPos.m_6630_(3), ((Block)AstrologicalBlocks.TENDRILS.get()).m_49966_());
                    }
                }
            }
        }
    }

    private static void replaceEndstone(Level level, BlockPos blockPos, BlockState blockState) {
        if (level.m_8055_(blockPos).m_60713_(Blocks.f_50259_)) {
            level.m_7731_(blockPos, blockState, 3);
        }
    }

    private static void placeOnCyst(Level level, BlockPos blockPos, BlockState blockState) {
        if ((level.m_8055_(blockPos.m_7495_()).m_60713_((Block)AstrologicalBlocks.TUMOR.get()) || level.m_8055_(blockPos.m_7495_()).m_60713_((Block)AstrologicalBlocks.TENDRILS.get())) && level.m_8055_(blockPos).m_60795_()) {
            level.m_7731_(blockPos, blockState, 3);
        }
    }
}

