/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.CryingDuctBlock;
import com.Apothic0n.Astrological.core.objects.CryoFireBlock;
import com.Apothic0n.Astrological.core.objects.HalfTransparentRotatedPillarBlock;
import com.Apothic0n.Astrological.core.objects.InsomniaVentBlock;
import com.Apothic0n.Astrological.core.objects.JadeBlock;
import com.Apothic0n.Astrological.core.objects.PrismaticBlock;
import com.Apothic0n.Astrological.core.objects.PrismaticBlockEntity;
import com.Apothic0n.Astrological.core.objects.PrismaticWallBlock;
import com.Apothic0n.Astrological.core.objects.TendrilsBlock;
import com.Apothic0n.Astrological.core.objects.TriphyliteBlock;
import com.Apothic0n.Astrological.core.sounds.AstrologicalSoundTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class AstrologicalBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"astrological");
    public static final RegistryObject<Block> SLEEP = BLOCKS.register("sleep", () -> new MangroveRootsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.4f).m_60977_().m_60918_(SoundType.f_56745_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> TENDRILS = BLOCKS.register("tendrils", () -> new TendrilsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283908_).m_280606_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60955_().m_60910_().m_60918_(SoundType.f_222469_).m_60977_().m_60913_(0.66f, 1.5f).m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> TUMOR = BLOCKS.register("tumor", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(SoundType.f_222469_).m_60913_(0.66f, 1.5f)));
    public static final RegistryObject<Block> CRYING_DUCT = BLOCKS.register("crying_duct", () -> new CryingDuctBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280606_().m_280658_(NoteBlockInstrument.HAT).m_60999_().m_60955_().m_60918_(AstrologicalSoundTypes.GLASSY_OBSIDIAN).m_60977_().m_60913_(1.5f, 3.0f).m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> INSOMNIA_VENT = BLOCKS.register("insomnia_vent", () -> new InsomniaVentBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60977_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 3.0f)));
    public static final RegistryObject<Block> CRYO_FIRE = BLOCKS.register("cryo_fire", () -> new CryoFireBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_280170_().m_60910_().m_60966_().m_60953_(p_152607_ -> 7).m_60999_().m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> OCHRE_SELENITE = BLOCKS.register("ochre_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60911_(0.989f).m_280658_(NoteBlockInstrument.HAT).m_60953_(p_152607_ -> 15).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.SELENITE).m_60955_()));
    public static final RegistryObject<Block> VERDANT_SELENITE = BLOCKS.register("verdant_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283769_).m_60911_(0.989f).m_280658_(NoteBlockInstrument.HAT).m_60953_(p_152607_ -> 15).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.SELENITE).m_60955_()));
    public static final RegistryObject<Block> PEARLESCENT_SELENITE = BLOCKS.register("pearlescent_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60911_(0.989f).m_280658_(NoteBlockInstrument.HAT).m_60953_(p_152607_ -> 15).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.SELENITE).m_60955_()));
    public static final RegistryObject<Block> PURPURITE = BLOCKS.register("purpurite", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(0.4f).m_60918_(SoundType.f_56736_).m_60999_()));
    public static final RegistryObject<Block> SELENITE_WALL = BLOCKS.register("selenite_wall", () -> new PrismaticWallBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60911_(0.989f).m_280658_(NoteBlockInstrument.HAT).m_60953_(AstrologicalBlocks.prismaticEmission(15)).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.SELENITE)));
    public static final RegistryObject<Block> PRISMATIC_SELENITE = BLOCKS.register("prismatic_selenite", () -> new PrismaticBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60911_(0.989f).m_280658_(NoteBlockInstrument.HAT).m_60953_(AstrologicalBlocks.prismaticEmission(15)).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.SELENITE)));
    public static final RegistryObject<Block> TRIPHYLITE = BLOCKS.register("triphylite", () -> new TriphyliteBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.TRIPHYLITE).m_60999_()));
    public static final RegistryObject<Block> JADE = BLOCKS.register("jade", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60953_(p_152607_ -> 1).m_60982_((state, getter, pos) -> true).m_60991_((state, getter, pos) -> true).m_60999_()));
    public static final RegistryObject<Block> REINFORCED_JADE = BLOCKS.register("reinforced_jade", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60911_(1.1f).m_60999_().m_60913_(1.25f, 4.2f).m_60918_(AstrologicalSoundTypes.JADE)));
    public static final RegistryObject<Block> JADE_BRICKS = BLOCKS.register("jade_bricks", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60999_()));
    public static final RegistryObject<Block> POLISHED_JADE = BLOCKS.register("polished_jade", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60999_()));
    public static final RegistryObject<Block> MARBLED_JADE_SLAB = BLOCKS.register("marbled_jade_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60999_()));
    public static final RegistryObject<Block> LIGHT_JADE = BLOCKS.register("light_jade", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60953_(p_152607_ -> 1).m_60982_((state, getter, pos) -> true).m_60991_((state, getter, pos) -> true).m_60999_()));
    public static final RegistryObject<Block> LIGHT_JADE_TILES = BLOCKS.register("light_jade_tiles", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60999_()));
    public static final RegistryObject<Block> CRACKED_LIGHT_JADE_TILES = BLOCKS.register("cracked_light_jade_tiles", () -> new JadeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60978_(1.5f).m_60918_(AstrologicalSoundTypes.JADE).m_60999_()));
    public static final RegistryObject<Block> PURPURITE_TILES = BLOCKS.register("purpurite_tiles", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60978_(0.4f).m_60918_(SoundType.f_56736_).m_60999_()));
    public static List<RegistryObject<Block>> blocksWithStairsSlabsAndWalls = List.of(PURPURITE, PURPURITE_TILES, TRIPHYLITE, JADE, JADE_BRICKS, POLISHED_JADE, REINFORCED_JADE, LIGHT_JADE, LIGHT_JADE_TILES, CRACKED_LIGHT_JADE_TILES);
    public static final List<Map<RegistryObject<Block>, RegistryObject<Block>>> wallBlocks = new ArrayList<Map<RegistryObject<Block>, RegistryObject<Block>>>(List.of());
    public static final List<Map<RegistryObject<Block>, RegistryObject<Block>>> stairBlocks = new ArrayList<Map<RegistryObject<Block>, RegistryObject<Block>>>(List.of());
    public static final List<Map<RegistryObject<Block>, RegistryObject<Block>>> slabBlocks = new ArrayList<Map<RegistryObject<Block>, RegistryObject<Block>>>(List.of());

    private AstrologicalBlocks() {
    }

    private static ToIntFunction<BlockState> prismaticEmission(int max) {
        return blockState -> {
            int power = (Integer)blockState.m_61143_((Property)PrismaticBlockEntity.PRISMATIC_POWER);
            if (power > 0) {
                power /= 2;
            }
            if (power > max) {
                power = max;
            }
            return power;
        };
    }

    public static void fixBlockRenderLayers() {
        CryoFireBlock.bootStrap();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SLEEP.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OCHRE_SELENITE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)VERDANT_SELENITE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)PEARLESCENT_SELENITE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TENDRILS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CRYING_DUCT.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CRYO_FIRE.get()), (RenderType)RenderType.m_110463_());
    }

    public static void generateStairsSlabsWalls() {
        for (int i = 0; i < blocksWithStairsSlabsAndWalls.size(); ++i) {
            RegistryObject<Block> baseBlock = blocksWithStairsSlabsAndWalls.get(i);
            wallBlocks.add(AstrologicalBlocks.createWallBlocks(baseBlock));
            stairBlocks.add(AstrologicalBlocks.createStairBlocks(baseBlock));
            slabBlocks.add(AstrologicalBlocks.createSlabBlocks(baseBlock));
        }
    }

    public static Map<RegistryObject<Block>, RegistryObject<Block>> createWallBlocks(RegistryObject<Block> baseBlock) {
        return Map.of(baseBlock, BLOCKS.register(baseBlock.getId().toString().substring(13) + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)baseBlock.get())))));
    }

    public static Map<RegistryObject<Block>, RegistryObject<Block>> createStairBlocks(RegistryObject<Block> baseBlock) {
        return Map.of(baseBlock, BLOCKS.register(baseBlock.getId().toString().substring(13) + "_stairs", () -> new StairBlock(((Block)baseBlock.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)baseBlock.get())))));
    }

    public static Map<RegistryObject<Block>, RegistryObject<Block>> createSlabBlocks(RegistryObject<Block> baseBlock) {
        return Map.of(baseBlock, BLOCKS.register(baseBlock.getId().toString().substring(13) + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)baseBlock.get())))));
    }
}

