/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.AstrologicalBaseFireBlock;
import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CryoFireBlock
extends AstrologicalBaseFireBlock {
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    private final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();

    public CryoFireBlock(BlockBehaviour.Properties p_53425_) {
        super(p_53425_, 1.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter(p_53497_ -> (Integer)p_53497_.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), CryoFireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_53491_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? DOWN_AABB : voxelshape;
    }

    public BlockState m_7417_(BlockState p_53458_, Direction p_53459_, BlockState p_53460_, LevelAccessor p_53461_, BlockPos p_53462_, BlockPos p_53463_) {
        return this.m_7898_(p_53458_, (LevelReader)p_53461_, p_53462_) ? this.getStateWithAge(p_53461_, p_53462_, (Integer)p_53458_.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    @Override
    public VoxelShape m_5940_(BlockState p_53474_, BlockGetter p_53475_, BlockPos p_53476_, CollisionContext p_53477_) {
        return this.shapesCache.get(p_53474_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_53427_) {
        return this.getStateForPlacement((BlockGetter)p_53427_.m_43725_(), p_53427_.m_8083_());
    }

    protected BlockState getStateForPlacement(BlockGetter p_53471_, BlockPos p_53472_) {
        BlockPos blockpos = p_53472_.m_7495_();
        BlockState blockstate = p_53471_.m_8055_(blockpos);
        if (!(this.canCatchFire(p_53471_, p_53472_, Direction.UP) || blockstate.m_60783_(p_53471_, blockpos, Direction.UP) || blockstate.m_60713_((Block)AstrologicalBlocks.SLEEP.get()))) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(p_53471_, p_53472_.m_121945_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState p_53454_, LevelReader p_53455_, BlockPos p_53456_) {
        BlockPos blockpos = p_53456_.m_7495_();
        return p_53455_.m_8055_(blockpos).m_60783_((BlockGetter)p_53455_, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)p_53455_, p_53456_) || p_53455_.m_8055_(blockpos).m_60713_((Block)AstrologicalBlocks.SLEEP.get());
    }

    public void m_213897_(BlockState p_221160_, ServerLevel p_221161_, BlockPos p_221162_, RandomSource p_221163_) {
        p_221161_.m_186460_(p_221162_, (Block)this, CryoFireBlock.getFireTickDelay(p_221161_.f_46441_));
        if (p_221161_.m_46469_().m_46207_(GameRules.f_46131_)) {
            BlockPos p_220765_ = p_221162_.m_7495_();
            BlockState blockstate = p_221161_.m_8055_(p_220765_);
            boolean flag = blockstate.isFireSource((LevelReader)p_221161_, p_221162_, Direction.UP);
            if (blockstate.m_60713_((Block)AstrologicalBlocks.SLEEP.get())) {
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50080_)) {
                p_221161_.m_46597_(p_220765_, Blocks.f_50723_.m_49966_());
            }
            int i = (Integer)p_221160_.m_61143_((Property)AGE);
            if (!flag && p_221161_.m_46471_() && this.isNearRain((Level)p_221161_, p_221162_) && p_221163_.m_188501_() < 0.2f + (float)i * 0.03f) {
                p_221161_.m_7471_(p_221162_, false);
                p_221161_.m_7471_(p_221162_, false);
            } else {
                boolean flag1;
                int j = Math.min(15, i + p_221163_.m_188503_(3) / 2);
                if (i != j) {
                    p_221160_ = (BlockState)p_221160_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                    p_221161_.m_7731_(p_221162_, p_221160_, 4);
                }
                if (!(flag || p_221161_.m_8055_(p_221162_.m_7495_()).m_60713_(Blocks.f_50080_) || p_221161_.m_8055_(p_221162_.m_7495_()).m_60713_(Blocks.f_50723_))) {
                    if (!this.isValidFireLocation((BlockGetter)p_221161_, p_221162_)) {
                        BlockPos blockpos = p_221162_.m_7495_();
                        if (!p_221161_.m_8055_(blockpos).m_60783_((BlockGetter)p_221161_, blockpos, Direction.UP) && !p_221161_.m_8055_(blockpos).m_60713_((Block)AstrologicalBlocks.SLEEP.get()) || i > 3) {
                            p_221161_.m_7471_(p_221162_, false);
                        }
                        return;
                    }
                    if (i == 15 && p_221163_.m_188503_(4) == 0 && !this.canCatchFire((BlockGetter)p_221161_, p_221162_.m_7495_(), Direction.UP)) {
                        p_221161_.m_7471_(p_221162_, false);
                        return;
                    }
                }
                int k = (flag1 = p_221161_.m_204166_(p_221162_).m_203656_(BiomeTags.f_263839_)) ? -50 : 0;
                this.tryCatchFire((Level)p_221161_, p_221162_.m_122029_(), 300 + k, p_221163_, i, Direction.WEST);
                this.tryCatchFire((Level)p_221161_, p_221162_.m_122024_(), 300 + k, p_221163_, i, Direction.EAST);
                this.tryCatchFire((Level)p_221161_, p_221162_.m_7495_(), 250 + k, p_221163_, i, Direction.UP);
                this.tryCatchFire((Level)p_221161_, p_221162_.m_7494_(), 250 + k, p_221163_, i, Direction.DOWN);
                this.tryCatchFire((Level)p_221161_, p_221162_.m_122012_(), 300 + k, p_221163_, i, Direction.SOUTH);
                this.tryCatchFire((Level)p_221161_, p_221162_.m_122019_(), 300 + k, p_221163_, i, Direction.NORTH);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutableblockpos.m_122154_((Vec3i)p_221162_, l, j1, i1);
                            int l1 = this.getIgniteOdds((LevelReader)p_221161_, (BlockPos)blockpos$mutableblockpos);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 40 + p_221161_.m_46791_().m_19028_() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || p_221163_.m_188503_(k1) > i2 || p_221161_.m_46471_() && this.isNearRain((Level)p_221161_, (BlockPos)blockpos$mutableblockpos)) continue;
                            int j2 = Math.min(15, i + p_221163_.m_188503_(5) / 4);
                            p_221161_.m_7731_((BlockPos)blockpos$mutableblockpos, this.getStateWithAge((LevelAccessor)p_221161_, (BlockPos)blockpos$mutableblockpos, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level p_53429_, BlockPos p_53430_) {
        return p_53429_.m_46758_(p_53430_) || p_53429_.m_46758_(p_53430_.m_122024_()) || p_53429_.m_46758_(p_53430_.m_122029_()) || p_53429_.m_46758_(p_53430_.m_122012_()) || p_53429_.m_46758_(p_53430_.m_122019_());
    }

    @Deprecated
    public int getBurnOdds(BlockState p_221165_) {
        return p_221165_.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)p_221165_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.burnOdds.getInt((Object)p_221165_.m_60734_());
    }

    @Deprecated
    public int getIgniteOdds(BlockState p_221167_) {
        return p_221167_.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)p_221167_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.igniteOdds.getInt((Object)p_221167_.m_60734_());
    }

    private void tryCatchFire(Level p_53432_, BlockPos p_53433_, int p_53434_, RandomSource p_53435_, int p_53436_, Direction face) {
        int i = p_53432_.m_8055_(p_53433_).getFlammability((BlockGetter)p_53432_, p_53433_, face);
        if (p_53435_.m_188503_(p_53434_) < i) {
            BlockState blockstate = p_53432_.m_8055_(p_53433_);
            blockstate.onCaughtFire(p_53432_, p_53433_, face, null);
            if (p_53435_.m_188503_(p_53434_ + 10) < 5 && !p_53432_.m_46758_(p_53433_)) {
                int j = Math.min(p_53434_ + p_53435_.m_188503_(5) / 4, 15);
                p_53432_.m_7731_(p_53433_, this.getStateWithAge((LevelAccessor)p_53432_, p_53433_, j), 3);
            } else {
                p_53432_.m_7471_(p_53433_, false);
            }
        }
    }

    private BlockState getStateWithAge(LevelAccessor p_53438_, BlockPos p_53439_, int p_53440_) {
        BlockState blockstate = CryoFireBlock.getState((BlockGetter)p_53438_, p_53439_);
        return blockstate.m_60713_((Block)AstrologicalBlocks.CRYO_FIRE.get()) ? (BlockState)blockstate.m_61124_((Property)AGE, (Comparable)Integer.valueOf(p_53440_)) : blockstate;
    }

    private boolean isValidFireLocation(BlockGetter p_53486_, BlockPos p_53487_) {
        if (p_53486_.equals(AstrologicalBlocks.SLEEP.get())) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(p_53486_, p_53487_.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getIgniteOdds(LevelReader p_221157_, BlockPos p_221158_) {
        for (Direction direction : Direction.values()) {
            if (!p_221157_.m_8055_(p_221158_.m_121945_(direction)).m_60713_((Block)AstrologicalBlocks.SLEEP.get())) continue;
            return 1;
        }
        if (!p_221157_.m_46859_(p_221158_)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = p_221157_.m_8055_(p_221158_.m_121945_(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((BlockGetter)p_221157_, p_221158_.m_121945_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    @Override
    @Deprecated
    protected boolean canBurn(BlockState p_53489_) {
        return this.getIgniteOdds(p_53489_) > 0;
    }

    @Override
    public void m_6807_(BlockState p_53479_, Level p_53480_, BlockPos p_53481_, BlockState p_53482_, boolean p_53483_) {
        super.m_6807_(p_53479_, p_53480_, p_53481_, p_53482_, p_53483_);
        p_53480_.m_186460_(p_53481_, (Block)this, CryoFireBlock.getFireTickDelay(p_53480_.f_46441_));
    }

    private static int getFireTickDelay(RandomSource p_221149_) {
        return 30 + p_221149_.m_188503_(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_53465_) {
        p_53465_.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    private void setFlammable(Block p_53445_, int p_53446_, int p_53447_) {
        if (p_53445_ == Blocks.f_50016_) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.igniteOdds.put((Object)p_53445_, p_53446_);
        this.burnOdds.put((Object)p_53445_, p_53447_);
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(pos).isFlammable(world, pos, face);
    }

    public static void bootStrap() {
        CryoFireBlock fireblock = (CryoFireBlock)((Object)AstrologicalBlocks.CRYO_FIRE.get());
        fireblock.setFlammable((Block)AstrologicalBlocks.SLEEP.get(), 5, 20);
    }
}

