/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.badge;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.advancement.SimpleDestroyTrigger;
import com.petrolpark.destroy.item.BadgeItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class Badge {
    protected ResourceLocation id;
    protected ItemEntry<BadgeItem> itemEntry;
    protected Ingredient duplicationIngredient = Ingredient.f_43901_;
    public SimpleDestroyTrigger advancementTrigger = null;

    public static ForgeRegistry<Badge> badgeRegistry() {
        return RegistryManager.ACTIVE.getRegistry(Destroy.BADGE_REGISTRY_KEY);
    }

    public void setDuplicationItem(Ingredient ingredient) {
        if (this.duplicationIngredient != Ingredient.f_43901_) {
            throw new UnsupportedOperationException("Cannot modify Badge's duplication Item");
        }
        this.duplicationIngredient = ingredient;
    }

    @Nullable
    public Ingredient getDuplicationIngredient() {
        return this.duplicationIngredient;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public CraftingRecipe getExampleDuplicationRecipe() {
        Ingredient ingredient = this.getDuplicationIngredient();
        if (ingredient == null) {
            return null;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemStack stack = BadgeItem.of((Player)minecraft.f_91074_, this, new Date(System.currentTimeMillis()));
        return new ShapelessRecipe(new ResourceLocation(this.getId().m_135827_(), "badge_duplication_" + this.getId().m_135815_()), this.getId().m_135827_() + "badge_duplication", CraftingBookCategory.MISC, stack, NonNullList.m_122783_((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), (Object[])new Ingredient[]{ingredient}));
    }

    public void setAdvancementTrigger(SimpleDestroyTrigger trigger) {
        if (this.advancementTrigger != null) {
            throw new UnsupportedOperationException("Cannot reset Badge advancement trigger");
        }
        this.advancementTrigger = trigger;
    }

    public void grantAdvancement(Player player) {
        if (this.advancementTrigger != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.advancementTrigger.trigger(serverPlayer);
        }
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new UnsupportedOperationException("Cannot change a Badge's ID");
        }
        this.id = id;
    }

    public void setBadgeItem(ItemEntry<BadgeItem> entry) {
        if (this.itemEntry != null) {
            throw new UnsupportedOperationException("Cannot reset a Badge's Item");
        }
        this.itemEntry = entry;
    }

    public Component getName() {
        return Component.m_237115_((String)Util.m_137492_((String)"badge", (ResourceLocation)this.getId()));
    }

    public Component getDescription() {
        return Component.m_237115_((String)(Util.m_137492_((String)"badge", (ResourceLocation)this.getId()) + ".description"));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BadgeItem getItem() {
        return (BadgeItem)((Object)this.itemEntry.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Badge)) return false;
        Badge badge = (Badge)obj;
        if (this.getId() == null) return false;
        if (badge.getId() != this.getId()) return false;
        return true;
    }

    @Nullable
    public static Badge getBadge(String namespace, String name) {
        return Badge.getBadge(new ResourceLocation(namespace, name));
    }

    @Nullable
    public static Badge getBadge(ResourceLocation id) {
        return (Badge)Badge.badgeRegistry().getValue(id);
    }
}

