/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.AgingBarrelBlockEntity;
import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class AgingBarrelBlock
extends HorizontalDirectionalBlock
implements IBE<AgingBarrelBlockEntity>,
IWrenchable,
ITransformableBlock {
    public static final BooleanProperty IS_OPEN = BooleanProperty.m_61465_((String)"open");
    public static final IntegerProperty PROGRESS = IntegerProperty.m_61631_((String)"progress", (int)0, (int)4);

    public AgingBarrelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)IS_OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState blockstate, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            if (be.tryOpen()) {
                DestroySoundEvents.AGING_BARREL_OPEN.playOnServer(level, (Vec3i)pos);
                DestroyAdvancements.OPEN_AGING_BARREL.award(level, player);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_()) {
                if (FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    be.checkRecipe();
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                IItemHandlerModifiable inv = (IItemHandlerModifiable)be.itemCapability.orElse((Object)new ItemStackHandler(1));
                boolean success = false;
                for (int slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack stackInSlot = inv.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    player.m_150109_().m_150079_(stackInSlot);
                    inv.setStackInSlot(slot, ItemStack.f_41583_);
                    success = true;
                }
                if (success) {
                    level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + player.m_217043_().m_188501_());
                }
            }
            return InteractionResult.PASS;
        });
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState newState = super.getRotatedBlockState(state, Direction.UP);
        if (newState != state) {
            this.playRotateSound(context.m_43725_(), context.m_8083_());
            this.updateAfterWrenched(state, context);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!DestroyBlocks.AGING_BARREL.has(worldIn.m_8055_(entityIn.m_20183_()))) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        this.withBlockEntityDo(worldIn, entityIn.m_20183_(), be -> {
            ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)be.inventory, (ItemStack)itemEntity.m_32055_().m_41777_(), (boolean)false);
            be.checkRecipe();
            if (insertItem.m_41619_()) {
                itemEntity.m_146870_();
                return;
            }
            itemEntity.m_32045_(insertItem);
        });
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null && be instanceof AgingBarrelBlockEntity) {
            AgingBarrelBlockEntity agingBarrelBE = (AgingBarrelBlockEntity)be;
            return agingBarrelBE.getLuminosity();
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)blockstate.m_61143_((Property)IS_OPEN)).booleanValue()) {
            return DestroyShapes.AGING_BARREL_OPEN.get((Direction)blockstate.m_61143_((Property)f_54117_));
        }
        return DestroyShapes.agingBarrelClosed((Integer)blockstate.m_61143_((Property)PROGRESS));
    }

    public VoxelShape m_5939_(BlockState blockstate, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof ItemEntity) {
            return DestroyShapes.AGING_BARREL_INTERIOR;
        }
        return this.m_5940_(blockstate, level, pos, context);
    }

    public VoxelShape m_6079_(BlockState blockstate, BlockGetter level, BlockPos pos) {
        return DestroyShapes.AGING_BARREL_OPEN_RAYTRACE.get((Direction)blockstate.m_61143_((Property)f_54117_));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        switch ((Integer)state.m_61143_((Property)PROGRESS)) {
            case 1: {
                return 3;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 15;
            }
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> ItemHelper.dropContents((Level)level, (BlockPos)pos, (IItemHandler)be.inventory));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
        return blockstate;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, IS_OPEN, PROGRESS});
        super.m_7926_(builder);
    }

    public Class<AgingBarrelBlockEntity> getBlockEntityClass() {
        return AgingBarrelBlockEntity.class;
    }

    public BlockEntityType<? extends AgingBarrelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.AGING_BARREL.get();
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)transform.rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }
}

