/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.BubbleCapBlockEntity;
import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BubbleCapBlock
extends Block
implements IBE<BubbleCapBlockEntity>,
IWrenchable {
    public static final DirectionProperty PIPE_FACE = BlockStateProperties.f_61374_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");

    public BubbleCapBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PIPE_FACE, (Comparable)Direction.NORTH)).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() == state.m_60734_() || isMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            be.attemptRotation(false);
            be.createOrAddToTower((LevelReader)worldIn);
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PIPE_FACE, TOP, BOTTOM});
        super.m_7926_(builder);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockPos posAbove = pos.m_7494_();
        boolean isAbove = posAbove.m_123342_() == neighbor.m_123342_();
        boolean isBelow = pos.m_123342_() - 1 == neighbor.m_123342_();
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            be.attemptRotation(false);
            if (isAbove || isBelow) {
                be.createOrAddToTower(level);
            }
        });
        BlockState stateAbove = level.m_8055_(posAbove);
        if (isBelow && stateAbove.m_60713_((Block)DestroyBlocks.BUBBLE_CAP.get())) {
            stateAbove.onNeighborChange(level, posAbove, pos);
        }
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            BubbleCapBlockEntity be = (BubbleCapBlockEntity)this.getBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
            if (be == null) {
                return InteractionResult.PASS;
            }
            if (be.attemptRotation(true)) {
                this.playRotateSound(context.m_43725_(), context.m_8083_());
                this.updateAfterWrenched(state, context);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        DestroyAdvancementBehaviour.setPlacedBy(level, pos, placer);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null && be instanceof BubbleCapBlockEntity) {
            BubbleCapBlockEntity bubbleCapBE = (BubbleCapBlockEntity)be;
            return bubbleCapBE.getLuminosity();
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return DestroyShapes.bubbleCap((Boolean)state.m_61143_((Property)BOTTOM), (Boolean)state.m_61143_((Property)TOP));
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    public BlockState stateForPositionInTower(Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(!level.m_8055_(pos.m_7494_()).m_60713_((Block)DestroyBlocks.BUBBLE_CAP.get())))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(!level.m_8055_(pos.m_7495_()).m_60713_((Block)DestroyBlocks.BUBBLE_CAP.get())));
    }

    public Class<BubbleCapBlockEntity> getBlockEntityClass() {
        return BubbleCapBlockEntity.class;
    }

    public BlockEntityType<? extends BubbleCapBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.BUBBLE_CAP.get();
    }
}

