/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.DynamiteBlockEntity;
import com.petrolpark.destroy.util.ExplosionHelper;
import com.petrolpark.destroy.world.explosion.ExcavationExplosion;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class DynamiteBlock
extends Block
implements IBE<DynamiteBlockEntity> {
    public DynamiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void explode(Level level, BlockPos pos, Entity source) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.withBlockEntityDo((BlockGetter)serverLevel, pos, be -> {
            ExcavationExplosion excavationExplosion = new ExcavationExplosion(level, source, pos, new AABB(be.excavationAreaLowerCorner, be.excavationAreaUpperCorner));
            ExplosionHelper.explode(serverLevel, excavationExplosion);
        });
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
        super.onCaughtFire(state, level, pos, direction, igniter);
        this.explode(level, pos, (Entity)igniter);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_276867_(pos)) {
            this.explode(level, pos, null);
        }
    }

    public Class<DynamiteBlockEntity> getBlockEntityClass() {
        return DynamiteBlockEntity.class;
    }

    public BlockEntityType<? extends DynamiteBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.DYNAMITE.get();
    }
}

