/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.PumpjackBlock;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.simibubi.create.content.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public interface IPumpjackStructuralBlock
extends IProxyHoveringInformation,
IWrenchable {
    public static final EnumProperty<Component> COMPONENT = EnumProperty.m_61587_((String)"component", Component.class);

    default public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (IPumpjackStructuralBlock.stillValid(level, pos, state)) {
            return DestroyShapes.getPumpJackShaper((Component)((Object)state.m_61143_(COMPONENT))).get((Direction)level.m_8055_(IPumpjackStructuralBlock.getMaster(level, pos, state)).m_61143_((Property)PumpjackBlock.FACING));
        }
        return DestroyShapes.BLOCK;
    }

    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (IPumpjackStructuralBlock.stillValid((BlockGetter)level, clickedPos, state)) {
            BlockPos masterPos = IPumpjackStructuralBlock.getMaster((BlockGetter)level, clickedPos, state);
            context = new UseOnContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), masterPos, context.m_43721_()));
            state = level.m_8055_(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public static void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (IPumpjackStructuralBlock.stillValid((BlockGetter)level, pos, state)) {
            level.m_46961_(IPumpjackStructuralBlock.getMaster((BlockGetter)level, pos, state), true);
        }
    }

    public static void playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (IPumpjackStructuralBlock.stillValid((BlockGetter)level, pos, state)) {
            BlockPos masterPos = IPumpjackStructuralBlock.getMaster((BlockGetter)level, pos, state);
            level.m_6801_(masterPos.hashCode(), masterPos, -1);
            if (!level.m_5776_() && player.m_7500_()) {
                level.m_46961_(masterPos, false);
            }
        }
    }

    public static BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, Block thisBlock) {
        Level realLevel;
        if (IPumpjackStructuralBlock.stillValid((BlockGetter)level, currentPos, state)) {
            BlockPos masterPos = IPumpjackStructuralBlock.getMaster((BlockGetter)level, currentPos, state);
            if (!level.m_183326_().m_183582_(masterPos, (Object)((Block)DestroyBlocks.PUMPJACK.get()))) {
                level.m_186460_(masterPos, (Block)DestroyBlocks.PUMPJACK.get(), 1);
            }
            return state;
        }
        if (!(level instanceof Level) || (realLevel = (Level)level).m_5776_()) {
            return state;
        }
        if (!realLevel.m_183326_().m_183582_(currentPos, (Object)thisBlock)) {
            realLevel.m_186460_(currentPos, thisBlock, 1);
        }
        return state;
    }

    public static void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!IPumpjackStructuralBlock.stillValid((BlockGetter)level, pos, state)) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    default public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return IPumpjackStructuralBlock.stillValid((BlockGetter)level, pos, state) ? IPumpjackStructuralBlock.getMaster((BlockGetter)level, pos, state) : pos;
    }

    public static BlockPos getMaster(BlockGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        if (targetedState.m_60713_((Block)DestroyBlocks.PUMPJACK_STRUCTURAL.get())) {
            return IPumpjackStructuralBlock.getMaster(level, targetedPos, targetedState);
        }
        return targetedPos;
    }

    public static boolean stillValid(BlockGetter level, BlockPos pos, BlockState state) {
        if (!(state.m_60734_() instanceof IPumpjackStructuralBlock)) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        return targetedState.m_60734_() instanceof PumpjackBlock;
    }

    public static enum Component implements StringRepresentable
    {
        FRONT,
        BACK,
        MIDDLE,
        TOP;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.m_82425_();
                if (IPumpjackStructuralBlock.stillValid((BlockGetter)level, targetPos, state)) {
                    manager.m_107367_(IPumpjackStructuralBlock.getMaster((BlockGetter)level, targetPos, state), bhr.m_82434_());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            if (!IPumpjackStructuralBlock.stillValid((BlockGetter)level, pos, blockState)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(IPumpjackStructuralBlock.getMaster((BlockGetter)level, pos, blockState));
            return set;
        }
    }
}

