/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.petrolpark.destroy.item.DestroyItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

public class MagicBeetrootShootsBlock
extends BushBlock
implements BonemealableBlock {
    public MagicBeetrootShootsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return DestroyShapes.MAGIC_BEETROOT_SEEDS;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.CROP;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && super.m_7898_(state, level, pos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(26) == 0 ? 1 : 0) != 0)) {
            level.m_46597_(pos, MagicBeetrootShootsBlock.getGrowthResult(random));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return DestroyItems.MAGIC_BEETROOT_SEEDS.asStack();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_46597_(pos, MagicBeetrootShootsBlock.getGrowthResult(random));
    }

    public static BlockState getGrowthResult(RandomSource random) {
        int roll = random.m_188503_(22);
        if (roll <= 1) {
            return DestroyBlocks.COAL_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 3) {
            return DestroyBlocks.COPPER_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 4) {
            return DestroyBlocks.DIAMOND_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 5) {
            return DestroyBlocks.EMERALD_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 8) {
            return DestroyBlocks.FLUORITE_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 10) {
            return DestroyBlocks.GOLD_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 12) {
            return DestroyBlocks.IRON_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 15) {
            return DestroyBlocks.LAPIS_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 17) {
            return DestroyBlocks.NICKEL_INFUSED_BEETROOT.getDefaultState();
        }
        if (roll <= 19) {
            return DestroyBlocks.REDSTONE_INFUSED_BEETROOT.getDefaultState();
        }
        return DestroyBlocks.ZINC_INFUSED_BEETROOT.getDefaultState();
    }
}

