/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.entity.PrimedBomb;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class PrimeableBombBlock
extends TntBlock {
    protected PrimedBombEntityFactory factory;

    public PrimeableBombBlock(BlockBehaviour.Properties properties, PrimedBombEntityFactory factory) {
        super(properties);
        this.factory = factory;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new PrimeableBombDispenseBehaviour());
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (this.factory == null || level.m_5776_()) {
            return;
        }
        PrimedBomb entity = this.factory.create(level, pos, state, igniter);
        level.m_7967_((Entity)entity);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)igniter, GameEvent.f_157776_, pos);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_() && this.factory != null) {
            PrimedBomb entity = this.factory.create(level, pos, null, explosion.m_252906_());
            int i = entity.m_32100_();
            entity.m_32085_((short)(level.f_46441_.m_188503_(i / 4) + i / 8));
            level.m_7967_((Entity)entity);
        }
    }

    public int getFuseTime(Level world, BlockPos pos, BlockState state) {
        return 80;
    }

    @FunctionalInterface
    public static interface PrimedBombEntityFactory {
        public PrimedBomb create(Level var1, BlockPos var2, @Nullable BlockState var3, @Nullable LivingEntity var4);
    }

    public class PrimeableBombDispenseBehaviour
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.m_7727_();
            BlockPos pos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            PrimedBomb bomb = PrimeableBombBlock.this.factory.create((Level)level, pos, null, null);
            level.m_7967_((Entity)bomb);
            level.m_6263_(null, bomb.m_20185_(), bomb.m_20186_(), bomb.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157810_, pos);
            stack.m_41774_(1);
            return stack;
        }
    }
}

