/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.RedstoneProgrammerBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.RedstoneProgrammerBehaviour;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.petrolpark.destroy.item.RedstoneProgrammerBlockItem;
import com.petrolpark.destroy.util.RedstoneProgram;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class RedstoneProgrammerBlock
extends HorizontalDirectionalBlock
implements IBE<RedstoneProgrammerBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public RedstoneProgrammerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)be.programmer, be.programmer.program::write));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return DestroyShapes.REDSTONE_PROGRAMMER;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (!level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 0);
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        this.updatePower(state, (Level)worldIn, pos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() == oldState.m_60734_() || isMoving) {
            return;
        }
        this.updatePower(state, worldIn, pos);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (stack.m_41720_() instanceof RedstoneProgrammerBlockItem) {
            RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, placer).ifPresent(program -> this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                be.programmer.program.unload();
                be.programmer.program = RedstoneProgram.read(() -> new RedstoneProgrammerBehaviour.BehaviourRedstoneProgram(be.programmer), program.write());
                program.unload();
            }));
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity be = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        RedstoneProgrammerBehaviour behaviour = (RedstoneProgrammerBehaviour)BlockEntityBehaviour.get((BlockEntity)be, RedstoneProgrammerBehaviour.TYPE);
        if (behaviour != null) {
            return List.of(RedstoneProgrammerBlockItem.withProgram(behaviour.program));
        }
        return List.of();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        RedstoneProgrammerBehaviour behaviour = (RedstoneProgrammerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, RedstoneProgrammerBehaviour.TYPE);
        if (behaviour != null) {
            return RedstoneProgrammerBlockItem.withProgram(behaviour.program);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void updatePower(BlockState state, Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() != level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withWater((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_()), context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<RedstoneProgrammerBlockEntity> getBlockEntityClass() {
        return RedstoneProgrammerBlockEntity.class;
    }

    public BlockEntityType<? extends RedstoneProgrammerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.REDSTONE_PROGRAMMER.get();
    }
}

