/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.SandCastleBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.SentimentalBehaviour;
import com.petrolpark.destroy.block.shape.DestroyShapes;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SandCastleBlock
extends Block
implements IBE<SandCastleBlockEntity> {
    public static final EnumProperty<Material> MATERIAL = EnumProperty.m_61587_((String)"material", Material.class);

    public SandCastleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(MATERIAL, (Comparable)((Object)Material.SAND)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MATERIAL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return DestroyShapes.SAND_CASTLE;
    }

    public static void setOwner(Level level, BlockPos pos, LivingEntity owner) {
        ((SentimentalBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, SentimentalBehaviour.TYPE)).setOwner(owner);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.m_5776_() && entity.canTrample(state, pos, fallDistance)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                Player player;
                be.sentimentalBehaviour.onRemove(state, entity instanceof Player ? (player = (Player)entity) : null);
            });
            level.m_46961_(pos, false);
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.sentimentalBehaviour.onRemove(state, player));
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            Player player;
            Entity patt3413$temp = explosion.m_253049_();
            be.sentimentalBehaviour.onRemove(state, patt3413$temp instanceof Player ? (player = (Player)patt3413$temp) : null);
        });
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    public Class<SandCastleBlockEntity> getBlockEntityClass() {
        return SandCastleBlockEntity.class;
    }

    public BlockEntityType<? extends SandCastleBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.SAND_CASTLE.get();
    }

    public static enum Material implements StringRepresentable
    {
        SAND,
        RED_SAND,
        SOUL_SAND;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

