/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block;

import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VatSideBlock
extends CopycatBlock
implements ISpecialBlockItemRequirement {
    public VatSideBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> blockEntityType) {
        return new SmartBlockEntityTicker();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            if (!(be instanceof VatSideBlockEntity)) {
                return InteractionResult.PASS;
            }
            VatSideBlockEntity vatSide = (VatSideBlockEntity)((Object)be);
            switch (vatSide.getDisplayType()) {
                case PIPE: {
                    return InteractionResult.PASS;
                }
                case NORMAL: {
                    vatSide.setDisplayType(vatSide.direction == Direction.UP ? VatSideBlockEntity.DisplayType.OPEN_VENT : VatSideBlockEntity.DisplayType.THERMOMETER);
                    return InteractionResult.SUCCESS;
                }
                case THERMOMETER: {
                    vatSide.setDisplayType(VatSideBlockEntity.DisplayType.BAROMETER);
                    return InteractionResult.SUCCESS;
                }
                case BAROMETER: 
                case OPEN_VENT: 
                case CLOSED_VENT: {
                    vatSide.setDisplayType(VatSideBlockEntity.DisplayType.NORMAL);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        });
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.withBlockEntityDo((BlockGetter)level, currentPos, be -> {
            if (!(be instanceof VatSideBlockEntity)) {
                return;
            }
            VatSideBlockEntity vatSide = (VatSideBlockEntity)((Object)be);
            vatSide.updateRedstone();
            if (facing != vatSide.direction) {
                return;
            }
            vatSide.updateDisplayType(facingPos);
            vatSide.setPowerFromAdjacentBlock(facingPos);
        });
        return state;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            VatSideBlockEntity vatSide;
            block5: {
                block4: {
                    if (!(be instanceof VatSideBlockEntity)) break block4;
                    vatSide = (VatSideBlockEntity)((Object)be);
                    if (vatSide.direction != null) break block5;
                }
                return;
            }
            if (!pos.m_121945_(vatSide.direction).equals((Object)neighbor)) {
                return;
            }
            vatSide.updateDisplayType(neighbor);
            vatSide.setPowerFromAdjacentBlock(neighbor);
        });
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (!(be instanceof VatSideBlockEntity)) {
                return;
            }
            VatSideBlockEntity vatSide = (VatSideBlockEntity)((Object)be);
            vatSide.updateRedstone();
        });
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (!(isMoving || be.getMaterial().equals(newState) || state.equals(newState))) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)be.getConsumedItem());
            }
        });
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> level.m_46597_(pos, be.getMaterial()));
        }
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return this.getPickBlockItemStack(pLevel, pPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getPickBlockItemStack(level, pos);
    }

    protected ItemStack getPickBlockItemStack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = this.getBlockEntity(level, pos);
        if (blockEntity instanceof VatSideBlockEntity) {
            VatSideBlockEntity vatSide = (VatSideBlockEntity)blockEntity;
            return vatSide.getConsumedItem();
        }
        return ItemStack.f_41583_;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return VatSideBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60734_().m_6104_(state, neighborState, dir);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return VatSideBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60792_(level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return VatSideBlock.getMaterial((BlockGetter)reader, (BlockPos)pos).m_60631_(reader, pos);
    }

    public BlockEntityType<? extends CopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ItemRequirement.NONE;
    }
}

