/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.display;

import com.petrolpark.destroy.chemistry.ClientMixture;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fluids.FluidStack;

public abstract class MixtureContentsDisplaySource
extends DisplaySource {
    private static DecimalFormat df = new DecimalFormat();
    protected final boolean molesNotConcentration;

    public MixtureContentsDisplaySource(boolean molesNotConcentration) {
        this.molesNotConcentration = molesNotConcentration;
    }

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        MutableComponent name;
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        String temperature = "";
        FluidStack fluidStack = this.getFluidStack(context);
        if (fluidStack == null || fluidStack.isEmpty()) {
            return tooltip;
        }
        CompoundTag mixtureTag = fluidStack.getOrCreateTag().m_128469_("Mixture");
        if (mixtureTag.m_128456_()) {
            name = fluidStack.getDisplayName().m_6881_();
        } else {
            boolean iupac = !context.sourceConfig().m_128471_("MoleculeNameType");
            DestroyLang.TemperatureUnit temperatureUnit = DestroyLang.TemperatureUnit.values()[context.sourceConfig().m_128451_("TemperatureUnit")];
            ClientMixture mixture = ReadOnlyMixture.readNBT(ClientMixture::new, mixtureTag);
            name = mixture.getName().m_6881_();
            temperature = temperatureUnit.of(mixture.getTemperature());
            tooltip.addAll(mixture.getContentsTooltip(iupac, true, this.molesNotConcentration, fluidStack.getAmount(), df).stream().map(c -> c.m_6881_()).toList());
        }
        if (!this.molesNotConcentration) {
            name.m_130946_(" " + fluidStack.getAmount()).m_7220_((Component)Lang.translateDirect((String)"generic.unit.millibuckets", (Object[])new Object[0]));
        }
        tooltip.add(0, name.m_130946_(" " + temperature));
        return tooltip;
    }

    @Nullable
    public abstract FluidStack getFluidStack(DisplayLinkContext var1);

    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine) {
            this.addTemperatureUnitSelection(builder);
        } else {
            this.addMoleculeNameTypeSelection(builder);
        }
    }

    private void addTemperatureUnitSelection(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 137, (si, l) -> si.forOptions(List.of(DestroyLang.translate("display_source.mixture.temperature_unit.kelvin", new Object[0]).component(), DestroyLang.translate("display_source.mixture.temperature_unit.celcius", new Object[0]).component(), DestroyLang.translate("display_source.mixture.temperature_unit.farenheit", new Object[0]).component())).titled(DestroyLang.translate("display_source.mixture.temperature_unit", new Object[0]).component()), "TemperatureUnit");
    }

    private void addMoleculeNameTypeSelection(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 137, (si, l) -> si.forOptions(List.of(DestroyLang.translate("display_source.mixture.molecule_name_type.iupac", new Object[0]).component(), DestroyLang.translate("display_source.mixture.molecule_name_type.common", new Object[0]).component())).titled(DestroyLang.translate("display_source.mixture.molecule_name_type", new Object[0]).component()), "MoleculeNameType");
    }

    static {
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
    }
}

