/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.AgingBarrelBlock;
import com.petrolpark.destroy.block.entity.behaviour.PollutingBehaviour;
import com.petrolpark.destroy.recipe.AgingRecipe;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class AgingBarrelBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Object agingRecipeKey = new Object();
    private static final int TANK_CAPACITY = 1000;
    public SmartInventory inventory = new SmartInventory(2, (SyncedBlockEntity)this, 1, false).whenContentsChanged($ -> this.checkRecipe()).forbidExtraction();
    protected SmartFluidTankBehaviour tank;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public LazyOptional<IItemHandlerModifiable> itemCapability = LazyOptional.of(() -> this.inventory);
    protected DirectBeltInputBehaviour beltBehaviour;
    protected PollutingBehaviour pollutingBehaviour;
    private int timer = -1;
    private int totalTime;

    public AgingBarrelBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState pBlockState) {
        super(pType, pos, pBlockState);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(() -> ((AgingBarrelBlockEntity)this).sendData());
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)this.tank.getCapability().orElse(null)}));
        this.beltBehaviour = new DirectBeltInputBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.beltBehaviour);
        this.pollutingBehaviour = new PollutingBehaviour(this);
        behaviours.add(this.pollutingBehaviour);
    }

    public void checkRecipe() {
        if (!this.m_58898_() || this.m_58904_().m_5776_()) {
            return;
        }
        List allRecipes = RecipeFinder.get((Object)agingRecipeKey, (Level)this.f_58857_, r -> r.m_6671_() == DestroyRecipeTypes.AGING.getType());
        List possibleRecipes = allRecipes.stream().filter(r -> {
            AgingRecipe recipe = (AgingRecipe)((Object)r);
            if (!((FluidIngredient)recipe.getFluidIngredients().get(0)).test(this.getTank().getFluid())) {
                return false;
            }
            ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
            availableItems.addAll(List.of(this.inventory.m_8020_(0), this.inventory.m_8020_(1)));
            boolean[] ingredientsMatched = new boolean[recipe.m_7527_().size()];
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
                boolean ingredientMatched = false;
                ItemStack extractedStack = ItemStack.f_41583_;
                for (ItemStack stack : availableItems) {
                    if (!ingredient.test(stack)) continue;
                    ingredientMatched = true;
                    extractedStack = stack;
                    break;
                }
                ingredientsMatched[i] = ingredientMatched;
                if (!ingredientMatched) {
                    return false;
                }
                availableItems.remove(extractedStack);
            }
            return true;
        }).collect(Collectors.toList());
        if (possibleRecipes.size() >= 1) {
            AgingRecipe recipe = (AgingRecipe)((Object)possibleRecipes.get(0));
            this.onTimerChange();
            this.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            this.inventory.m_6211_();
            this.getTank().fill((FluidStack)recipe.getFluidResults().get(0), IFluidHandler.FluidAction.EXECUTE);
            this.totalTime = recipe.getProcessingDuration();
            this.timer = recipe.getProcessingDuration();
            this.tank.forbidExtraction();
            this.tank.forbidInsertion();
        }
    }

    public int getLuminosity() {
        if (this.timer == -1 && !this.getTank().isEmpty()) {
            FluidStack fluidStack = this.getTank().getFluid();
            return fluidStack.getRawFluid().getFluidType().getLightLevel(fluidStack);
        }
        return 0;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.timer = compound.m_128451_("Timer");
        this.totalTime = compound.m_128451_("TotalTime");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("Timer", this.timer);
        compound.m_128405_("TotalTime", this.totalTime);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        if (this.timer > 0) {
            --this.timer;
            this.onTimerChange();
        }
        super.tick();
    }

    public void onTimerChange() {
        if (!this.m_58898_()) {
            return;
        }
        BlockState oldState = this.m_58900_();
        BlockState newState = this.m_58900_();
        newState = (BlockState)oldState.m_61124_((Property)AgingBarrelBlock.IS_OPEN, (Comparable)Boolean.valueOf(this.timer < 0));
        if (this.timer <= 0) {
            this.tank.allowExtraction();
            this.tank.allowInsertion();
        }
        if (this.timer == -1) {
            newState = (BlockState)newState.m_61124_((Property)AgingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0));
        }
        newState = (BlockState)newState.m_61124_((Property)AgingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0));
        if ((newState = (BlockState)newState.m_61124_((Property)AgingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(this.totalTime != 0 ? 4 - (int)((float)this.timer / (float)this.totalTime * 4.0f) : 0))) != oldState) {
            this.m_58904_().m_46597_(this.m_58899_(), newState);
            this.sendData();
            if ((Integer)newState.m_61143_((Property)AgingBarrelBlock.PROGRESS) != 0) {
                DestroySoundEvents.AGING_BARREL_BALLOON.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
            }
            if (this.timer < 0) {
                DestroySoundEvents.AGING_BARREL_OPEN.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
            }
        }
    }

    public boolean tryOpen() {
        if (!this.m_58898_() || this.m_58904_().m_5776_()) {
            return false;
        }
        if (this.timer == 0) {
            this.timer = -1;
            this.onTimerChange();
            return true;
        }
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.fluidCapability);
        if (this.timer != -1) {
            DestroyLang.translate("tooltip.aging_barrel.progress", (int)((0.995 - (double)((float)this.timer / (float)this.totalTime)) * 100.0) + "%").style(ChatFormatting.WHITE).forGoggles(tooltip);
        }
        return true;
    }

    public SmartFluidTank getTank() {
        return this.tank.getPrimaryHandler();
    }

    public SmartFluidTankBehaviour.TankSegment getTankToRender() {
        return this.tank.getPrimaryTank();
    }
}

