/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.Destroy;
import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.BubbleCapBlock;
import com.petrolpark.destroy.block.display.MixtureContentsDisplaySource;
import com.petrolpark.destroy.block.entity.IDirectionalOutputFluidBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.PollutingBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour.GeniusFluidTankBehaviour;
import com.petrolpark.destroy.client.particle.DestroyParticleTypes;
import com.petrolpark.destroy.client.particle.data.GasParticleData;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.DistillationTower;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.VecHelper;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BubbleCapBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IDirectionalOutputFluidBlockEntity {
    private static final DecimalFormat df = new DecimalFormat();
    private static final int TANK_CAPACITY = 1000;
    private static final int TRANSFER_SPEED = 20;
    private Direction pipeFace;
    private int fraction;
    private int ticksToFill;
    public FluidStack particleFluid;
    private boolean isController;
    private BlockPos towerControllerPos;
    private DistillationTower tower;
    protected SmartFluidTankBehaviour internalTank;
    protected SmartFluidTankBehaviour tank;
    protected LazyOptional<IFluidHandler> allFluidCapability;
    protected DestroyAdvancementBehaviour advancementBehaviour;
    protected PollutingBehaviour pollutingBehaviour;
    private int initializationTicks;
    public static MixtureContentsDisplaySource DISPLAY_SOURCE;

    public BubbleCapBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.pipeFace = (Direction)state.m_61143_((Property)BubbleCapBlock.PIPE_FACE);
        this.fraction = 0;
        this.isController = false;
        this.towerControllerPos = pos;
        this.ticksToFill = 0;
        this.particleFluid = FluidStack.EMPTY;
        this.initializationTicks = 3;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new GeniusFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.OUTPUT, this, 1, 1000, true).whenFluidUpdates(() -> ((BubbleCapBlockEntity)this).notifyUpdate());
        this.internalTank = new GeniusFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.INPUT, this, 1, 1000, true).forbidExtraction().forbidInsertion().whenFluidUpdates(() -> ((BubbleCapBlockEntity)this).notifyUpdate());
        behaviours.add((BlockEntityBehaviour)this.tank);
        behaviours.add((BlockEntityBehaviour)this.internalTank);
        this.allFluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)this.tank.getCapability().orElse(null), (IFluidHandler)this.internalTank.getCapability().orElse(null)}));
        this.advancementBehaviour = new DestroyAdvancementBehaviour(this);
        behaviours.add(this.advancementBehaviour);
        this.pollutingBehaviour = new PollutingBehaviour(this);
        behaviours.add(this.pollutingBehaviour);
    }

    public void remove() {
        if (!this.m_58898_() || this.m_58904_().m_5776_()) {
            super.remove();
        }
        this.removeFromDistillationTower();
        super.remove();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        BlockEntity be;
        super.read(compound, clientPacket);
        if (!this.m_58898_()) {
            return;
        }
        this.fraction = compound.m_128451_("Fraction");
        int[] controllerPosArray = compound.m_128465_("DistillationTowerControllerPosition");
        this.towerControllerPos = controllerPosArray.length == 0 ? this.m_58899_() : new BlockPos(controllerPosArray[0], controllerPosArray[1], controllerPosArray[2]);
        if (compound.m_128441_("DistillationTower")) {
            this.isController = true;
            this.tower = new DistillationTower(compound.m_128469_("DistillationTower"), this.m_58904_(), this.m_58899_());
        }
        if ((be = this.m_58904_().m_7702_(this.towerControllerPos)) instanceof BubbleCapBlockEntity) {
            BubbleCapBlockEntity controllerBubbleCap = (BubbleCapBlockEntity)be;
            if (controllerBubbleCap.isController) {
                this.tower = controllerBubbleCap.getDistillationTower();
            }
        }
        if (clientPacket) {
            this.particleFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("ParticleFluid"));
        }
        this.ticksToFill = compound.m_128451_("TicksToFill");
        this.pipeFace = (Direction)this.m_58900_().m_61143_((Property)BubbleCapBlock.PIPE_FACE);
        this.initializationTicks = compound.m_128451_("InitializationTicks");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Fraction", this.fraction);
        compound.m_128408_("DistillationTowerControllerPosition", List.of(Integer.valueOf(this.towerControllerPos.m_123341_()), Integer.valueOf(this.towerControllerPos.m_123342_()), Integer.valueOf(this.towerControllerPos.m_123343_())));
        if (this.isController) {
            compound.m_128365_("DistillationTower", (Tag)this.tower.serializeNBT());
        }
        compound.m_128405_("TicksToFill", this.ticksToFill);
        if (clientPacket) {
            compound.m_128365_("ParticleFluid", (Tag)this.particleFluid.writeToNBT(new CompoundTag()));
        }
        compound.m_128405_("InitializationTicks", this.initializationTicks);
    }

    public void tick() {
        super.tick();
        if (!this.particleFluid.isEmpty()) {
            if (this.m_58904_().m_5776_()) {
                this.spawnParticles(this.particleFluid);
            }
            this.particleFluid = FluidStack.EMPTY;
        }
        if (this.initializationTicks > 0) {
            --this.initializationTicks;
        }
        if (this.ticksToFill > 0) {
            --this.ticksToFill;
            if (this.ticksToFill == 0) {
                DestroySoundEvents.DISTILLATION_TOWER_CONDENSE.playOnServer(this.m_58904_(), (Vec3i)this.m_58899_());
            }
        }
        if (this.ticksToFill <= 0 && !this.internalTank.isEmpty()) {
            this.internalTank.allowInsertion();
            FluidStack transferredFluid = this.getInternalTank().drain(20, IFluidHandler.FluidAction.EXECUTE);
            this.internalTank.forbidInsertion();
            this.getTank().fill(transferredFluid, IFluidHandler.FluidAction.EXECUTE);
        }
        if (!this.m_58898_()) {
            return;
        }
        if (this.isController && this.m_58898_()) {
            this.tower.tick(this.m_58904_());
        }
        this.sendData();
    }

    public void onDistill() {
        if (!this.isController) {
            return;
        }
        DestroySoundEvents.DISTILLATION_TOWER_BOIL.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
        this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.DISTILL);
    }

    public static int getTankCapacity() {
        return 1000;
    }

    public static int getTransferRate() {
        return 20;
    }

    public SmartFluidTank getTank() {
        return this.tank.getPrimaryHandler();
    }

    public SmartFluidTank getInternalTank() {
        return this.internalTank.getPrimaryHandler();
    }

    public SmartFluidTankBehaviour.TankSegment getTankToRender() {
        return this.tank.getPrimaryTank();
    }

    public int getLuminosity() {
        if (this.getTank().isEmpty()) {
            return 0;
        }
        FluidStack fluidStack = this.getTank().getFluid();
        return fluidStack.getRawFluid().getFluidType().getLightLevel(fluidStack);
    }

    public void setTicksToFill(int ticks) {
        this.ticksToFill = ticks;
    }

    public void addToDistillationTower(DistillationTower tower) {
        this.tower = tower;
        this.towerControllerPos = tower.getControllerPos();
        this.fraction = tower.getHeight();
        this.isController = this.fraction == 0;
        this.sendData();
    }

    public void spawnParticles(FluidStack fluidStack) {
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.m_58899_());
        if (!(this.m_58898_() && this.m_58904_().m_5776_() && this.isController)) {
            return;
        }
        GasParticleData particleData = new GasParticleData(DestroyParticleTypes.DISTILLATION.get(), fluidStack, (float)this.getDistillationTower().getHeight() - 1.3f);
        for (int i = 0; i < 10; ++i) {
            this.m_58904_().m_7106_((ParticleOptions)particleData, center.f_82479_, center.f_82480_ - (double)0.3f, center.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void removeFromDistillationTower() {
        if (this.tower == null) {
            return;
        }
        this.tower.removeBubbleCap(this);
    }

    public void createOrAddToTower(LevelReader level) {
        BubbleCapBlockEntity bubbleCapBelow;
        BlockEntity belowBE = level.m_7702_(this.m_58899_().m_7495_());
        if (belowBE == null || !(belowBE instanceof BubbleCapBlockEntity) || (bubbleCapBelow = (BubbleCapBlockEntity)belowBE).getDistillationTower() == null) {
            this.tower = new DistillationTower(this.m_58904_(), this.m_58899_());
        } else {
            bubbleCapBelow.getDistillationTower().addBubbleCap(this);
        }
    }

    public DistillationTower getDistillationTower() {
        if (!this.m_58898_()) {
            Destroy.LOGGER.warn("Tried to access Distillation Tower of Bubble Cap at " + this.m_58899_().m_123344_() + " but it has no assigned Level.");
            return null;
        }
        return this.tower;
    }

    @Nonnull
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == this.pipeFace) {
                return this.tank.getCapability().cast();
            }
            if (side == null) {
                return this.allFluidCapability.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.allFluidCapability.invalidate();
    }

    public boolean attemptRotation(boolean shouldSwitch) {
        if (!this.m_58898_()) {
            return false;
        }
        if (this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BubbleCapBlock)this.m_58900_().m_60734_()).stateForPositionInTower(this.m_58904_(), this.m_58899_()).m_61124_((Property)BubbleCapBlock.PIPE_FACE, (Comparable)this.refreshDirection(this, shouldSwitch ? this.pipeFace.m_122427_() : this.pipeFace, (FluidTank)this.getTank(), !this.isController)))) {
            this.pipeFace = (Direction)this.m_58900_().m_61143_((Property)BubbleCapBlock.PIPE_FACE);
            this.notifyUpdate();
            return true;
        }
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.initializationTicks > 0) {
            return false;
        }
        DistillationTower clientTower = this.getDistillationTower();
        if (clientTower == null) {
            return false;
        }
        if (clientTower.getControllerBubbleCap() == null) {
            return false;
        }
        if (this.isController) {
            DestroyLang.translate("tooltip.bubble_cap.reboiler", new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        } else {
            DestroyLang.builder().add(Component.m_237115_((String)"block.destroy.bubble_cap")).style(ChatFormatting.WHITE).space().add(Component.m_237113_((String)(this.fraction + "/" + (clientTower.getHeight() - 1)))).forGoggles(tooltip);
        }
        SmartFluidTank inputTank = clientTower.getControllerBubbleCap().getTank();
        DestroyLang.fluidContainerInfoHeader(tooltip);
        if (!this.isController) {
            DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.bubble_cap.output_tank", new Object[0]), (FluidTank)this.getTank());
        }
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.bubble_cap.input_tank", new Object[0]), (FluidTank)inputTank);
        DestroyLang.TemperatureUnit unit = (DestroyLang.TemperatureUnit)((Object)DestroyAllConfigs.CLIENT.chemistry.temperatureUnit.get());
        if (this.isController) {
            DestroyLang.translate("tooltip.bubble_cap.reboiler_temperature", unit.of(DistillationTower.getTemperatureForDistillationTower(this.m_58904_(), this.f_58858_), df)).forGoggles(tooltip);
        }
        return true;
    }

    static {
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(0);
        DISPLAY_SOURCE = new MixtureContentsDisplaySource(false){

            @Override
            public FluidStack getFluidStack(DisplayLinkContext context) {
                BlockEntity blockEntity = context.getSourceBlockEntity();
                if (blockEntity instanceof BubbleCapBlockEntity) {
                    BubbleCapBlockEntity bubbleCap = (BubbleCapBlockEntity)blockEntity;
                    return bubbleCap.getTank().getFluid();
                }
                return null;
            }

            public Component getName() {
                return DestroyLang.translate("display_source.bubble_cap", new Object[0]).component();
            }
        };
    }
}

