/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.CentrifugeBlock;
import com.petrolpark.destroy.block.display.MixtureContentsDisplaySource;
import com.petrolpark.destroy.block.entity.IDirectionalOutputFluidBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.PollutingBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour.GeniusFluidTankBehaviour;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.recipe.CentrifugationRecipe;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CentrifugeBlockEntity
extends KineticBlockEntity
implements IDirectionalOutputFluidBlockEntity {
    private static final Object centrifugationRecipeKey = new Object();
    private static final int TANK_CAPACITY = 1000;
    private SmartFluidTankBehaviour inputTank;
    private SmartFluidTankBehaviour denseOutputTank;
    private SmartFluidTankBehaviour lightOutputTank;
    protected LazyOptional<IFluidHandler> allFluidCapability;
    protected DestroyAdvancementBehaviour advancementBehaviour;
    protected PollutingBehaviour pollutingBehaviour;
    private Direction denseOutputTankFace;
    private int lubricationLevel;
    private static final int MAX_LUBRICATION_LEVEL = 10;
    public int timer;
    private CentrifugationRecipe lastRecipe;
    private boolean pondering;
    public static CentrifugeDisplaySource INPUT_DISPLAY_SOURCE = new CentrifugeDisplaySource("input", CentrifugeBlockEntity::getInputTank);
    public static CentrifugeDisplaySource DENSE_OUTPUT_DISPLAY_SOURCE = new CentrifugeDisplaySource("dense_output", CentrifugeBlockEntity::getDenseOutputTank);
    public static CentrifugeDisplaySource LIGHT_OUTPIT_DISPLAY_SOURCE = new CentrifugeDisplaySource("light_output", CentrifugeBlockEntity::getLightOutputTank);

    public CentrifugeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.denseOutputTankFace = (Direction)state.m_61143_((Property)CentrifugeBlock.DENSE_OUTPUT_FACE);
        this.lubricationLevel = 1;
        this.pondering = false;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new GeniusFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::onFluidStackChanged);
        this.denseOutputTank = new GeniusFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::onFluidStackChanged).forbidInsertion();
        this.lightOutputTank = new GeniusFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::onFluidStackChanged).forbidInsertion();
        behaviours.addAll(List.of(this.inputTank, this.denseOutputTank, this.lightOutputTank));
        this.allFluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)this.inputTank.getCapability().orElse(null), (IFluidHandler)this.denseOutputTank.getCapability().orElse(null), (IFluidHandler)this.lightOutputTank.getCapability().orElse(null)}));
        this.advancementBehaviour = new DestroyAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
        this.pollutingBehaviour = new PollutingBehaviour((SmartBlockEntity)this);
        behaviours.add(this.pollutingBehaviour);
    }

    public boolean attemptRotation(boolean shouldSwitch) {
        if (!this.m_58898_()) {
            return false;
        }
        if (this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CentrifugeBlock.DENSE_OUTPUT_FACE, (Comparable)this.refreshDirection((SmartBlockEntity)this, shouldSwitch ? this.denseOutputTankFace.m_122427_() : this.denseOutputTankFace, (FluidTank)this.getDenseOutputTank(), true)), 6)) {
            this.denseOutputTankFace = (Direction)this.m_58900_().m_61143_((Property)CentrifugeBlock.DENSE_OUTPUT_FACE);
            this.notifyUpdate();
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.m_58898_()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.isTankFull((FluidTank)this.getDenseOutputTank()) || this.isTankFull((FluidTank)this.getLightOutputTank())) {
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.m_58904_().m_5776_()) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            this.sendData();
            return;
        }
        if (this.inputTank.isEmpty()) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.getRequiredFluid().test(this.getInputTank().getFluid())) {
            List possibleRecipes = RecipeFinder.get((Object)centrifugationRecipeKey, (Level)this.m_58904_(), r -> r.m_6671_() == DestroyRecipeTypes.CENTRIFUGATION.getType()).stream().filter(r -> {
                CentrifugationRecipe recipe = (CentrifugationRecipe)((Object)r);
                if (!recipe.getRequiredFluid().test(this.getInputTank().getFluid())) {
                    return false;
                }
                return this.canFitFluidInTank(recipe.getDenseOutputFluid(), (FluidTank)this.getDenseOutputTank()) && this.canFitFluidInTank(recipe.getLightOutputFluid(), (FluidTank)this.getLightOutputTank());
            }).collect(Collectors.toList());
            this.lastRecipe = possibleRecipes.size() >= 1 ? (CentrifugationRecipe)((Object)possibleRecipes.get(0)) : null;
        }
        this.timer = this.lastRecipe == null ? 100 : this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lubricationLevel = compound.m_128451_("Lubrication");
        this.timer = compound.m_128451_("Timer");
        this.getInputTank().readFromNBT(compound.m_128469_("InputTank"));
        this.getDenseOutputTank().readFromNBT(compound.m_128469_("DenseOutputTank"));
        this.getLightOutputTank().readFromNBT(compound.m_128469_("LightOutputTank"));
        this.denseOutputTankFace = (Direction)this.m_58900_().m_61143_((Property)CentrifugeBlock.DENSE_OUTPUT_FACE);
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Lubrication", this.lubricationLevel);
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputTank", (Tag)this.getInputTank().writeToNBT(new CompoundTag()));
        compound.m_128365_("DenseOutputTank", (Tag)this.getDenseOutputTank().writeToNBT(new CompoundTag()));
        compound.m_128365_("LightOutputTank", (Tag)this.getLightOutputTank().writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        float lubricationMultiplier = this.lubricationLevel / 10;
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() * lubricationMultiplier / 16.0f)), (int)1, (int)512);
    }

    public SmartFluidTank getInputTank() {
        return this.inputTank.getPrimaryHandler();
    }

    public SmartFluidTank getDenseOutputTank() {
        return this.denseOutputTank.getPrimaryHandler();
    }

    public SmartFluidTank getLightOutputTank() {
        return this.lightOutputTank.getPrimaryHandler();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() {
        if (this.lastRecipe == null) {
            if (!DestroyFluids.isMixture(this.getInputTank().getFluid())) return;
            ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, this.getInputTank().getFluid().getOrCreateChildTag("Mixture"));
            if (mixture == null) {
                return;
            }
            if (!DestroyFluids.isMixture(this.getDenseOutputTank().getFluid()) && !this.getDenseOutputTank().isEmpty() || !DestroyFluids.isMixture(this.getLightOutputTank().getFluid()) && !this.getLightOutputTank().isEmpty()) {
                return;
            }
            int amount = IntStream.of(this.getInputTank().getFluidAmount(), this.getDenseOutputTank().getSpace() * 2, this.getLightOutputTank().getSpace() * 2).min().getAsInt();
            if (amount == 0) {
                return;
            }
            float totalVolume = (float)amount / 1000.0f;
            ArrayList chargedMolecules = new ArrayList();
            ArrayList<Molecule> neutralMolecules = new ArrayList<Molecule>();
            for (Molecule molecule2 : mixture.getContents(false)) {
                (molecule2.getCharge() == 0 ? neutralMolecules : chargedMolecules).add(molecule2);
            }
            Collections.sort(neutralMolecules, (m1, m2) -> Float.compare(m1.getDensity(), m2.getDensity()));
            float volumeOfDenseMixture = 0.0f;
            ReadOnlyMixture lightMixture = new ReadOnlyMixture();
            ReadOnlyMixture denseMixture = new ReadOnlyMixture();
            float totalMoles = 0.0f;
            for (Molecule molecule3 : neutralMolecules) {
                totalMoles += mixture.getConcentrationOf(molecule3) * totalVolume;
            }
            for (Molecule molecule3 : neutralMolecules) {
                float moles = mixture.getConcentrationOf(molecule3) * totalVolume;
                float volume = totalVolume * moles / totalMoles;
                float volumeInDenseMixture = Math.min(totalVolume / 2.0f - volumeOfDenseMixture, volume);
                volumeOfDenseMixture += volumeInDenseMixture;
                denseMixture.addMolecule(molecule3, 2.0f * (moles * volumeInDenseMixture / volume) / totalVolume);
                lightMixture.addMolecule(molecule3, 2.0f * (moles * (volume - volumeInDenseMixture) / volume) / totalVolume);
            }
            ReadOnlyMixture ionMixture = denseMixture.getConcentrationOf(DestroyMolecules.WATER) > 0.0f || lightMixture.getConcentrationOf(DestroyMolecules.WATER) <= 0.0f ? denseMixture : lightMixture;
            chargedMolecules.forEach(molecule -> ionMixture.addMolecule((Molecule)molecule, 2.0f * mixture.getConcentrationOf((Molecule)molecule)));
            this.getInputTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
            this.getDenseOutputTank().fill(MixtureFluid.of(amount / 2, denseMixture), IFluidHandler.FluidAction.EXECUTE);
            this.getLightOutputTank().fill(MixtureFluid.of(amount / 2, lightMixture), IFluidHandler.FluidAction.EXECUTE);
            this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.USE_CENTRIFUGE);
            this.notifyUpdate();
            return;
        } else {
            if (!this.canFitFluidInTank(this.lastRecipe.getDenseOutputFluid(), (FluidTank)this.getDenseOutputTank()) || !this.canFitFluidInTank(this.lastRecipe.getLightOutputFluid(), (FluidTank)this.getLightOutputTank()) || this.hasFluidInTank(this.lastRecipe.getRequiredFluid(), (FluidTank)this.getLightOutputTank())) {
                return;
            }
            this.getInputTank().drain(this.lastRecipe.getRequiredFluid().getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.getDenseOutputTank().fill(this.lastRecipe.getDenseOutputFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.getLightOutputTank().fill(this.lastRecipe.getLightOutputFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.USE_CENTRIFUGE);
            this.notifyUpdate();
        }
    }

    public void spawnParticles() {
        FluidStack fluidStack = this.inputTank.getPrimaryHandler().getFluid();
        if (fluidStack.isEmpty() || !this.m_58898_()) {
            return;
        }
        RandomSource random = this.m_58904_().m_213780_();
        ParticleOptions data = FluidFX.getFluidParticle((FluidStack)fluidStack);
        float angle = random.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, (double)0.7f);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)random, (float)0.0078125f);
        this.m_58904_().m_7106_(data, center.f_82479_, center.f_82480_, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == Direction.UP) {
                return this.inputTank.getCapability().cast();
            }
            if (side == Direction.DOWN) {
                return this.lightOutputTank.getCapability().cast();
            }
            if (side == this.denseOutputTankFace || this.pondering) {
                return this.denseOutputTank.getCapability().cast();
            }
            if (side == null) {
                return this.allFluidCapability.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.allFluidCapability.invalidate();
    }

    public int getEachTankCapacity() {
        return 1000;
    }

    private void onFluidStackChanged() {
        this.notifyUpdate();
    }

    public void setPondering() {
        this.pondering = true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        DestroyLang.fluidContainerInfoHeader(tooltip);
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.centrifuge.input_tank", new Object[0]), (FluidTank)this.getInputTank());
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.centrifuge.dense_output_tank", new Object[0]), (FluidTank)this.getDenseOutputTank());
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.centrifuge.light_output_tank", new Object[0]), (FluidTank)this.getLightOutputTank());
        return true;
    }

    public static class CentrifugeDisplaySource
    extends MixtureContentsDisplaySource {
        private final Function<CentrifugeBlockEntity, SmartFluidTank> tankGetter;
        private final String tankId;

        private CentrifugeDisplaySource(String tankId, Function<CentrifugeBlockEntity, SmartFluidTank> tankGetter) {
            super(false);
            this.tankId = tankId;
            this.tankGetter = tankGetter;
        }

        @Override
        public FluidStack getFluidStack(DisplayLinkContext context) {
            BlockEntity blockEntity = context.getSourceBlockEntity();
            if (blockEntity instanceof CentrifugeBlockEntity) {
                CentrifugeBlockEntity centrifuge = (CentrifugeBlockEntity)blockEntity;
                return this.tankGetter.apply(centrifuge).getFluid();
            }
            return FluidStack.EMPTY;
        }

        public Component getName() {
            return DestroyLang.translate("display_source.centrifuge." + this.tankId, new Object[0]).component();
        }
    }
}

