/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.CoolerBlock;
import com.petrolpark.destroy.chemistry.Molecule;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.chemistry.index.DestroyMolecules;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.PollutionHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoolerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int MAX_COOLING_TICKS = 12000;
    private static final int TANK_CAPACITY = 1000;
    private SmartFluidTankBehaviour tank;
    private int coolingTicks = 0;
    protected LerpedFloat headAnimation = LerpedFloat.linear();
    protected LerpedFloat headAngle = LerpedFloat.angular();

    public CoolerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)Direction.NORTH) + 180.0f) % 360.0f));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(this::consumeFluid).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    private void consumeFluid() {
        if (!this.m_58898_()) {
            return;
        }
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid();
        if (DestroyFluids.isMixture(fluidStack)) {
            int amount = fluidStack.getAmount();
            ReadOnlyMixture mixture = ReadOnlyMixture.readNBT(ReadOnlyMixture::new, fluidStack.getOrCreateChildTag("Mixture"));
            float totalMolesPerBucket = 0.0f;
            float totalRefrigerantMolesPerBucket = 0.0f;
            float coolingPower = 0.0f;
            for (Molecule molecule : mixture.getContents(true)) {
                float concentration = mixture.getConcentrationOf(molecule);
                totalMolesPerBucket += concentration;
                if (!molecule.hasTag(DestroyMolecules.Tags.REFRIGERANT)) continue;
                totalRefrigerantMolesPerBucket += concentration;
                coolingPower += concentration * (float)amount * molecule.getMolarHeatCapacity() / 100.0f;
            }
            if ((coolingPower *= totalRefrigerantMolesPerBucket / totalMolesPerBucket) > 0.0f) {
                this.setColdnessOfBlock(ColdnessLevel.FROSTING);
                this.coolingTicks = (int)((float)this.coolingTicks + coolingPower);
                if (this.coolingTicks >= 12000) {
                    this.tank.forbidInsertion();
                }
            }
        }
        this.tank.getPrimaryHandler().drain(1000, IFluidHandler.FluidAction.EXECUTE);
        PollutionHelper.pollute(this.m_58904_(), fluidStack);
        this.notifyUpdate();
    }

    public void tick() {
        super.tick();
        if (!this.m_58898_()) {
            return;
        }
        if (this.m_58904_().m_5776_()) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getColdnessFromBlock());
            }
            return;
        }
        if (this.coolingTicks > 0) {
            --this.coolingTicks;
            if (this.coolingTicks < 12000) {
                this.tank.allowInsertion();
            }
            if (this.coolingTicks <= 0) {
                this.setColdnessOfBlock(ColdnessLevel.IDLE);
            }
            this.sendData();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.coolingTicks = tag.m_128451_("Timer");
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("Timer", this.coolingTicks);
    }

    public SmartFluidTank getInputTank() {
        return this.tank.getPrimaryHandler();
    }

    public LerpedFloat getHeadAnimation() {
        return this.headAnimation;
    }

    public LerpedFloat getHeadAngle() {
        return this.headAngle;
    }

    public void updateHeatLevel(ColdnessLevel coldnessLevel) {
        if (!this.m_58898_()) {
            return;
        }
        BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)(coldnessLevel == ColdnessLevel.FROSTING ? BlazeBurnerBlock.HeatLevel.valueOf((String)"FROSTING") : BlazeBurnerBlock.HeatLevel.NONE));
        if (!newState.equals(this.m_58900_())) {
            this.m_58904_().m_46597_(this.m_58899_(), newState);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAnimation() {
        float target = 0.0f;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_20145_()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.m_20185_();
                z = player.m_20189_();
            }
            double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
            double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
            target = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
        this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.headAngle.tickChaser();
        this.headAnimation.chase(this.validBlockAbove() ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    protected void spawnParticles(ColdnessLevel coldnessLevel) {
        if (!this.m_58898_()) {
            return;
        }
        if (coldnessLevel == ColdnessLevel.NONE) {
            return;
        }
        RandomSource r = this.m_58904_().m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.m_58899_());
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(coldnessLevel == ColdnessLevel.IDLE ? 32 : 2) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60812_((BlockGetter)this.m_58904_(), this.m_58899_().m_7494_()).m_83281_();
        if (empty || r.m_188503_(8) == 0) {
            this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.07, 0.0);
        }
    }

    private boolean validBlockAbove() {
        if (!this.m_58898_()) {
            return false;
        }
        BlockState blockState = this.m_58904_().m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof FluidTankBlock;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.tank.getCapability().invalidate();
    }

    public ColdnessLevel getColdnessFromBlock() {
        return CoolerBlock.getColdnessLevelOf(this.m_58900_());
    }

    public void setColdnessOfBlock(ColdnessLevel coldnessLevel) {
        if (!this.m_58898_()) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CoolerBlock.COLD_LEVEL, (Comparable)((Object)coldnessLevel)));
        this.updateHeatLevel(coldnessLevel);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.coolingTicks <= 0) {
            return false;
        }
        int seconds = this.coolingTicks % 1200 / 20;
        Object timeRemaining = this.coolingTicks < 72000 ? this.coolingTicks / 1200 + ":" + (seconds < 10 ? "0" : "") + seconds : DestroyLang.translate("tooltip.cooler.long_time_remaining", new Object[0]).string();
        DestroyLang.translate("tooltip.cooler.time_remaining", timeRemaining).forGoggles(tooltip);
        return true;
    }

    public static enum ColdnessLevel implements StringRepresentable
    {
        NONE,
        IDLE,
        FROSTING;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

