/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.DifferentialBlock;
import com.petrolpark.destroy.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.destroy.block.entity.LongShaftBlockEntity;
import com.petrolpark.destroy.mixin.accessor.RotationPropagatorAccessor;
import com.petrolpark.destroy.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DifferentialBlockEntity
extends SplitShaftBlockEntity {
    public float oldControlSpeed;

    public DifferentialBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (connectedViaAxes || LongShaftBlockEntity.connectedToLongShaft((KineticBlockEntity)this, target, diff)) {
            if (target instanceof DifferentialBlockEntity) {
                return 0.0f;
            }
            return this.ratio(stateFrom) * Math.signum(RotationPropagatorAccessor.invokeGetAxisModifier(target, KineticsHelper.directionBetween(target.m_58899_(), this.m_58899_())));
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void setSource(BlockPos source) {
        super.setSource(source);
        Direction directionBetween = KineticsHelper.directionBetween(this.m_58899_(), source);
        if (this.m_58898_() && (directionBetween == null || directionBetween.m_122434_() != this.m_58900_().m_61143_((Property)DifferentialBlock.AXIS))) {
            this.m_58904_().m_46961_(this.m_58899_(), true);
        }
    }

    public void tick() {
        BlockEntity blockEntity;
        BlockPos adjacentPos;
        super.tick();
        if (!this.m_58898_()) {
            return;
        }
        Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(this.m_58900_());
        BlockPos otherAdjacentPos = this.m_58899_().m_121945_(direction.m_122424_());
        if (this.getSpeed() == 0.0f && !this.propagatesToMe(adjacentPos = this.m_58899_().m_121945_(direction), direction.m_122424_()) && this.propagatesToMe(otherAdjacentPos, direction)) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)DestroyBlocks.DUMMY_DIFFERENTIAL.getDefaultState().m_61124_((Property)DifferentialBlock.AXIS, (Comparable)direction.m_122434_())).m_61124_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.m_122421_() == Direction.AxisDirection.NEGATIVE)));
        }
        if ((blockEntity = this.m_58904_().m_7702_(otherAdjacentPos)) instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
            this.oldControlSpeed = this.getPropagatedSpeed(kbe, direction);
        }
    }

    public void removeSource() {
        super.removeSource();
        if (this.m_58898_()) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61122_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION));
        }
    }

    public float ratio(BlockState stateFrom) {
        Direction towardsInput = DirectionalRotatedPillarKineticBlock.getDirection(stateFrom);
        Direction towardsControl = towardsInput.m_122424_();
        BlockPos inputPos = this.m_58899_().m_121945_(towardsInput);
        BlockPos controlPos = this.m_58899_().m_121945_(towardsControl);
        BlockEntity inputBE = this.m_58904_().m_7702_(inputPos);
        float inputSpeed = 0.0f;
        if (this.propagatesToMe(inputPos, towardsControl) && inputBE instanceof KineticBlockEntity) {
            KineticBlockEntity inputKBE = (KineticBlockEntity)inputBE;
            inputSpeed = this.getPropagatedSpeed(inputKBE, towardsControl);
        }
        BlockEntity controlBE = this.m_58904_().m_7702_(controlPos);
        float controlSpeed = 0.0f;
        if (this.propagatesToMe(controlPos, towardsInput) && controlBE instanceof KineticBlockEntity) {
            KineticBlockEntity controlKBE = (KineticBlockEntity)controlBE;
            controlSpeed = this.getPropagatedSpeed(controlKBE, towardsInput);
        }
        if (inputSpeed + controlSpeed == 0.0f) {
            return 0.0f;
        }
        return 2.0f * inputSpeed / (inputSpeed + controlSpeed);
    }

    public boolean propagatesToMe(BlockPos pos, Direction directionToMe) {
        KineticBlock kineticBlock;
        if (!this.m_58898_()) {
            return false;
        }
        BlockState state = this.m_58904_().m_8055_(pos);
        Block block = state.m_60734_();
        return block instanceof KineticBlock && (kineticBlock = (KineticBlock)block).hasShaftTowards((LevelReader)this.m_58904_(), pos, state, directionToMe);
    }

    public float getPropagatedSpeed(KineticBlockEntity from, Direction directionToMe) {
        if (from instanceof DifferentialBlockEntity) {
            return 0.0f;
        }
        return from.getSpeed() * RotationPropagatorAccessor.invokeGetAxisModifier(from, directionToMe);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        super.addPropagationLocations(block, state, neighbours);
        KineticsHelper.addLargeCogwheelPropagationLocations(this.f_58858_, neighbours);
        return neighbours;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return true;
    }

    public float getRotationSpeedModifier(Direction face) {
        return this.ratio(this.m_58900_());
    }
}

