/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.entity.ISpecialWhenHovered;
import com.petrolpark.destroy.block.entity.behaviour.SidedScrollValueBehaviour;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DynamiteBlockEntity
extends SmartBlockEntity
implements ISpecialWhenHovered {
    public BlockPos excavationAreaUpperCorner;
    public BlockPos excavationAreaLowerCorner = this.m_58899_();
    protected SidedScrollValueBehaviour scrollValueBehaviour;
    private int initializationTicks = 3;

    public DynamiteBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.excavationAreaUpperCorner = this.m_58899_();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.scrollValueBehaviour = new SidedScrollValueBehaviour((Component)DestroyLang.translate("tooltip.dynamite.excavation_radius", new Object[0]).component(), this, (ValueBoxTransform)new DynamiteValueBox()).between(0, 10).oppositeSides().withCallback((d, i) -> this.updateExcavationArea());
        Arrays.fill(this.scrollValueBehaviour.values, 2);
        behaviours.add(this.scrollValueBehaviour);
        this.updateExcavationArea();
    }

    public void tick() {
        super.tick();
        if (this.initializationTicks > 0) {
            --this.initializationTicks;
            if (this.initializationTicks == 1) {
                this.updateExcavationArea();
            }
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.excavationAreaUpperCorner = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("UpperCorner"));
        this.excavationAreaLowerCorner = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LowerCorner"));
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("UpperCorner", (Tag)NbtUtils.m_129224_((BlockPos)this.excavationAreaUpperCorner));
        tag.m_128365_("LowerCorner", (Tag)NbtUtils.m_129224_((BlockPos)this.excavationAreaLowerCorner));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void whenLookedAt(LocalPlayer player, BlockHitResult blockHitResult) {
        CreateClient.OUTLINER.chaseAABB((Object)Pair.of((Object)"excavationArea", (Object)this.m_58899_()), new AABB(this.excavationAreaLowerCorner, this.excavationAreaUpperCorner)).colored(-2621359);
    }

    private void updateExcavationArea() {
        this.excavationAreaLowerCorner = this.m_58899_();
        this.excavationAreaUpperCorner = this.m_58899_();
        int[] values = this.scrollValueBehaviour.values;
        for (Direction direction : Direction.values()) {
            if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.excavationAreaUpperCorner = this.excavationAreaUpperCorner.m_5484_(direction, values[direction.m_122424_().ordinal()] + 1);
                continue;
            }
            this.excavationAreaLowerCorner = this.excavationAreaLowerCorner.m_5484_(direction, values[direction.m_122424_().ordinal()]);
        }
        this.sendData();
    }

    protected class DynamiteValueBox
    extends ValueBoxTransform.Sided {
        protected DynamiteValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)15.5);
        }
    }
}

