/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.behaviour.ChargingBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.recipe.ChargingRecipe;
import com.petrolpark.destroy.recipe.DestroyRecipeTypes;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DynamoBlockEntity
extends BasinOperatingBlockEntity
implements ChargingBehaviour.ChargingBehaviourSpecifics {
    private static final Object electrolysisRecipeKey = new Object();
    public ChargingBehaviour chargingBehaviour;
    protected DestroyAdvancementBehaviour advancementBehaviour;
    public int soundDuration = 0;
    private static final RecipeWrapper chargingInventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public DynamoBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.chargingBehaviour = new ChargingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.chargingBehaviour);
        this.advancementBehaviour = new DestroyAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public void onItemCharged(ItemStack stack) {
        this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.CHARGE_WITH_DYNAMO);
    }

    public void tick() {
        super.tick();
        if (this.soundDuration > 0) {
            --this.soundDuration;
        } else if (this.isRunning()) {
            DestroySoundEvents.DYNAMO_CRACKLE.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
            this.soundDuration = 80;
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.soundDuration = compound.m_128451_("SoundDuration");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("SoundDuration", this.soundDuration);
    }

    public void onSpeedChanged(float prevSpeed) {
        if (this.m_58898_()) {
            this.m_58904_().m_46672_(this.m_58899_(), (Block)DestroyBlocks.DYNAMO.get());
        }
        super.onSpeedChanged(prevSpeed);
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        this.applyBasinRecipe();
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<ChargingRecipe> recipe = this.getChargingRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        List outputs = RecipeApplier.applyRecipeOn((Level)this.m_58904_(), (ItemStack)(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1)), (Recipe)((Recipe)recipe.get()));
        for (ItemStack createdItemStack : outputs) {
            if (createdItemStack.m_41619_()) continue;
            this.onItemCharged(createdItemStack);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        if (!this.m_58898_()) {
            return false;
        }
        ItemStack itemStack = itemEntity.m_32055_();
        Optional<ChargingRecipe> recipe = this.getChargingRecipe(itemStack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemStackCreated = ItemStack.f_41583_;
        if (this.canProcessInBulk() || itemStack.m_41613_() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)((Recipe)recipe.get()));
            itemStackCreated = itemEntity.m_32055_().m_41777_();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.m_58904_(), (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (Recipe)((Recipe)recipe.get()))) {
                if (itemStackCreated.m_41619_()) {
                    itemStackCreated = result.m_41777_();
                }
                ItemEntity createdItemEntity = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                createdItemEntity.m_32060_();
                createdItemEntity.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.m_58904_().f_46441_, (float)0.05f));
                this.m_58904_().m_7967_((Entity)createdItemEntity);
            }
            itemStack.m_41774_(1);
        }
        if (!itemStackCreated.m_41619_()) {
            this.onItemCharged(itemStackCreated);
        }
        return true;
    }

    @Override
    public boolean canProcessInBulk() {
        return (Boolean)DestroyAllConfigs.SERVER.contraptions.dynamoBulkCharging.get();
    }

    @Override
    public void onChargingCompleted() {
        if (this.chargingBehaviour.mode == ChargingBehaviour.Mode.BASIN && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            this.startProcessingBasin();
        } else {
            this.basinChecker.scheduleUpdate();
        }
    }

    public void startProcessingBasin() {
        if (this.chargingBehaviour.running && this.chargingBehaviour.runningTicks <= 240) {
            return;
        }
        super.startProcessingBasin();
        this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.ELECTROLYZE_WITH_DYNAMO);
        this.chargingBehaviour.start(ChargingBehaviour.Mode.BASIN, Vec3.m_82539_((Vec3i)this.m_58899_().m_6625_(2)).m_82520_(0.0, (double)(0.125f + this.getBasin().map(basin -> {
            IFluidHandler fluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
            if (fluidHandler == null) {
                return Float.valueOf(0.0f);
            }
            int totalFluid = 0;
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                totalFluid += fluidHandler.getFluidInTank(i).getAmount();
            }
            return Float.valueOf(0.75f * Mth.m_14036_((float)((float)totalFluid / 2000.0f), (float)0.0f, (float)1.0f));
        }).orElse(Float.valueOf(0.0f)).floatValue()), 0.0));
    }

    public Optional<ChargingRecipe> getChargingRecipe(ItemStack itemStack) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.m_58904_(), (ItemStack)itemStack, DestroyRecipeTypes.CHARGING.getType(), ChargingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        chargingInventory.m_6836_(0, itemStack);
        return DestroyRecipeTypes.CHARGING.find(chargingInventory, this.m_58904_());
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public boolean isRunning() {
        return this.chargingBehaviour.running;
    }

    public Vec3 getLightningTargetPosition() {
        return this.chargingBehaviour.targetPosition;
    }

    protected void onBasinRemoved() {
        this.chargingBehaviour.running = false;
        this.chargingBehaviour.runningTicks = 0;
        this.sendData();
    }

    public int getRedstoneSignal() {
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 256.0f), (float)0.0f, (float)1.0f), (float)0.0f, (float)15.0f);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == DestroyRecipeTypes.ELECTROLYSIS.getType();
    }

    protected Object getRecipeCacheKey() {
        return electrolysisRecipeKey;
    }
}

