/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public interface IDirectionalOutputFluidBlockEntity {
    default public boolean isTankFull(FluidTank tank) {
        return tank.getFluidAmount() == tank.getCapacity();
    }

    default public boolean canFitFluidInTank(FluidStack stack, FluidTank tank) {
        return (stack.getFluid() == tank.getFluid().getFluid() || tank.isEmpty()) && stack.getAmount() <= tank.getSpace();
    }

    default public boolean hasFluidInTank(FluidIngredient ingredient, FluidTank tank) {
        if (tank.drain(ingredient.getRequiredAmount(), IFluidHandler.FluidAction.SIMULATE).getAmount() != ingredient.getRequiredAmount()) {
            return false;
        }
        for (FluidStack stack : ingredient.getMatchingFluidStacks()) {
            if (stack.getFluid() != tank.getFluid().getFluid()) continue;
            return true;
        }
        return false;
    }

    default public Direction refreshDirection(SmartBlockEntity be, Direction currentDirection, FluidTank tank, boolean output) {
        if (!be.m_58898_() || currentDirection.m_122434_() == Direction.Axis.Y) {
            return Direction.NORTH;
        }
        Direction direction = currentDirection;
        for (int i = 0; i < 4; ++i) {
            FluidTransportBehaviour transport;
            BlockEntity adjacentBE = be.m_58904_().m_7702_(be.m_58899_().m_121945_(direction));
            BlockState adjacentState = be.m_58904_().m_8055_(be.m_58899_().m_121945_(direction));
            if (adjacentBE != null && (transport = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockEntity)adjacentBE, (BehaviourType)FluidTransportBehaviour.TYPE)) != null) {
                if (output && transport.canPullFluidFrom(tank.getFluid(), adjacentState, direction.m_122424_())) {
                    return direction;
                }
                if (!output && transport.canHaveFlowToward(adjacentState, direction.m_122424_())) {
                    return direction;
                }
                if (FluidPipeBlock.isPipe((BlockState)adjacentState) || adjacentState.m_60734_() instanceof GlassFluidPipeBlock && direction.m_122434_() != adjacentState.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
                    return direction;
                }
            }
            direction = direction.m_122427_();
        }
        return currentDirection;
    }
}

