/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.PollutometerBlock;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.util.DestroyLang;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PollutometerBlockEntity
extends SmartBlockEntity {
    private LevelPollution.PollutionType pollutionType = LevelPollution.PollutionType.RADIOACTIVITY;
    protected ScrollOptionBehaviour<LevelPollution.PollutionType> pollutionTypeDisplay;
    private static final ValueBoxTransform.Sided slot = new ValueBoxTransform.Sided(){

        public Vec3 getLocalOffset(BlockState state) {
            return VecHelper.rotateCentered((Vec3)this.getSouthLocation(), (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == state.m_61143_((Property)PollutometerBlock.DIRECTION);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)6.0, (double)12.75);
        }
    };

    public PollutometerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.pollutionTypeDisplay = new ScrollOptionBehaviour(LevelPollution.PollutionType.class, (Component)DestroyLang.translate("tooltip.pollutometer.pollution_type", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.pollutionTypeDisplay.withCallback(this::setPollutionType);
        behaviours.add((BlockEntityBehaviour)this.pollutionTypeDisplay);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        int pollutionTypeIndex = tag.m_128451_("PollutionType");
        this.setPollutionType(pollutionTypeIndex);
        this.pollutionTypeDisplay.value = pollutionTypeIndex;
        super.read(tag, clientPacket);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("PollutionType", this.pollutionType.ordinal());
        super.write(tag, clientPacket);
    }

    public LevelPollution.PollutionType getPollutionType() {
        return this.pollutionType;
    }

    private void setPollutionType(Integer pollutionTypeIndex) {
        this.pollutionType = LevelPollution.PollutionType.values()[pollutionTypeIndex];
    }
}

