/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.PumpjackBlock;
import com.petrolpark.destroy.block.entity.PumpjackCamBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.PollutingBehaviour;
import com.petrolpark.destroy.capability.chunk.ChunkCrudeOil;
import com.petrolpark.destroy.fluid.DestroyFluids;
import com.petrolpark.destroy.sound.DestroySoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

public class PumpjackBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartFluidTankBehaviour tank;
    protected PollutingBehaviour pollutionBehaviour;
    protected DestroyAdvancementBehaviour advancementBehaviour;
    public WeakReference<PumpjackCamBlockEntity> source = new WeakReference<Object>(null);
    private boolean upsqueak = false;

    public PumpjackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 1, 2000, false).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.advancementBehaviour = new DestroyAdvancementBehaviour(this);
        behaviours.add(this.advancementBehaviour);
        this.pollutionBehaviour = new PollutingBehaviour(this);
        behaviours.add(this.pollutionBehaviour);
    }

    public void tick() {
        super.tick();
        PumpjackCamBlockEntity cam = this.getCam();
        if (!this.m_58898_()) {
            return;
        }
        if (cam == null) {
            return;
        }
        if (!cam.m_58899_().m_121996_((Vec3i)this.m_58899_()).equals((Object)cam.pumpjackPos)) {
            cam.update(this.m_58899_());
            this.sendData();
            return;
        }
        Direction facing = PumpjackBlock.getFacing(this.m_58900_());
        if (this.m_58904_().m_46749_(this.m_58899_().m_121945_(facing.m_122424_()))) {
            cam.update(this.m_58899_());
        }
        if (this.m_58904_().m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playClientSound());
            return;
        }
        if (cam.getSpeed() == 0.0f) {
            return;
        }
        BlockPos pipePos = this.m_58899_().m_121945_(facing);
        LevelChunk chunk = this.f_58857_.m_46745_(pipePos);
        LazyOptional crudeOilOptional = chunk.getCapability(ChunkCrudeOil.Provider.CHUNK_CRUDE_OIL);
        if (!crudeOilOptional.isPresent()) {
            return;
        }
        int oilAmount = crudeOilOptional.map(crudeOilCap -> {
            crudeOilCap.generate(chunk, this.advancementBehaviour.getPlayer());
            return crudeOilCap.getAmount();
        }).orElse(0);
        if (oilAmount == 0) {
            return;
        }
        this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.USE_PUMPJACK);
        this.tank.allowInsertion();
        int amountPumped = this.tank.getPrimaryHandler().fill(new FluidStack((Fluid)DestroyFluids.CRUDE_OIL.get(), (int)Math.min((float)oilAmount, Math.abs(cam.getSpeed() / 16.0f))), IFluidHandler.FluidAction.EXECUTE);
        this.tank.forbidInsertion();
        crudeOilOptional.ifPresent(crudeOilCap -> crudeOilCap.decreaseAmount(amountPumped));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || PumpjackBlock.getFacing(this.m_58900_()).m_122434_() != side.m_122434_() && side.m_122434_() != Direction.Axis.Y)) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public Float getTargetAngle() {
        float angle = 0.0f;
        BlockState blockState = this.m_58900_();
        if (!DestroyBlocks.PUMPJACK.has(blockState)) {
            return null;
        }
        PumpjackCamBlockEntity cam = this.getCam();
        if (cam == null) {
            return null;
        }
        Direction facing = PumpjackBlock.getFacing(blockState);
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)cam);
        angle = KineticBlockEntityRenderer.getAngleForTe((KineticBlockEntity)cam, (BlockPos)cam.m_58899_(), (Direction.Axis)axis);
        if (axis.m_122479_() && facing.m_122434_() == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playClientSound() {
        if (this.getTargetAngle() == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (Math.abs(this.getTargetAngle().floatValue()) <= 0.1f && this.upsqueak) {
            DestroySoundEvents.PUMPJACK_CREAK_1.play(this.m_58904_(), (Player)minecraft.f_91074_, (Vec3i)this.m_58899_());
            this.upsqueak = false;
        }
        if ((double)Math.abs(Math.abs(this.getTargetAngle().floatValue()) - (float)Math.PI) < 0.1 && !this.upsqueak) {
            DestroySoundEvents.PUMPJACK_CREAK_2.play(this.m_58904_(), (Player)minecraft.f_91074_, (Vec3i)this.m_58899_());
            this.upsqueak = true;
        }
    }

    @Nullable
    public PumpjackCamBlockEntity getCam() {
        PumpjackCamBlockEntity cam = (PumpjackCamBlockEntity)((Object)this.source.get());
        if (cam == null || cam.m_58901_() || !cam.canPower(this.m_58899_())) {
            PumpjackCamBlockEntity newCam;
            if (cam != null) {
                this.source = new WeakReference<Object>(null);
            }
            Direction facing = PumpjackBlock.getFacing(this.m_58900_());
            BlockEntity anyCamAt = this.m_58904_().m_7702_(this.m_58899_().m_5484_(facing, 1));
            if (anyCamAt instanceof PumpjackCamBlockEntity && (newCam = (PumpjackCamBlockEntity)anyCamAt).canPower(this.m_58899_())) {
                cam = newCam;
                this.source = new WeakReference<PumpjackCamBlockEntity>(cam);
            }
        }
        return cam;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }
}

