/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PumpjackCamBlockEntity
extends KineticBlockEntity {
    public BlockPos pumpjackPos;
    private int initialTicks = 3;

    public PumpjackCamBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
    }

    protected Block getStressConfigKey() {
        return (Block)DestroyBlocks.PUMPJACK.get();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.initialTicks = compound.m_128451_("Warmup");
        if (compound.m_128425_("PumpjackPos", 10)) {
            this.pumpjackPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("PumpjackPos"));
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Warmup", this.initialTicks);
        if (this.pumpjackPos != null) {
            compound.m_128365_("PumpjackPos", (Tag)NbtUtils.m_129224_((BlockPos)this.pumpjackPos));
        }
    }

    public void update(BlockPos sourcePos) {
        this.pumpjackPos = this.m_58899_().m_121996_((Vec3i)sourcePos);
    }

    public void remove(BlockPos sourcePos) {
        if (!this.isPowering(sourcePos)) {
            return;
        }
        this.pumpjackPos = null;
    }

    public boolean canPower(BlockPos globalPos) {
        return this.initialTicks == 0 && (this.pumpjackPos == null || this.isPowering(globalPos));
    }

    public boolean isPowering(BlockPos globalPos) {
        BlockPos key = this.m_58899_().m_121996_((Vec3i)globalPos);
        return key.equals((Object)this.pumpjackPos);
    }
}

