/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.advancement.DestroyAdvancements;
import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.VatControllerBlock;
import com.petrolpark.destroy.block.display.MixtureContentsDisplaySource;
import com.petrolpark.destroy.block.entity.DestroyBlockEntityTypes;
import com.petrolpark.destroy.block.entity.ISpecialWhenHovered;
import com.petrolpark.destroy.block.entity.VatSideBlockEntity;
import com.petrolpark.destroy.block.entity.behaviour.DestroyAdvancementBehaviour;
import com.petrolpark.destroy.block.entity.behaviour.fluidTankBehaviour.VatFluidTankBehaviour;
import com.petrolpark.destroy.capability.level.pollution.LevelPollution;
import com.petrolpark.destroy.chemistry.Mixture;
import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.chemistry.ReadOnlyMixture;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.fluid.MixtureFluid;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.ExplosionHelper;
import com.petrolpark.destroy.util.PollutionHelper;
import com.petrolpark.destroy.util.vat.Vat;
import com.petrolpark.destroy.world.explosion.SmartExplosion;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class VatControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
ISpecialWhenHovered {
    public static final float AIR_PRESSURE = 101000.0f;
    protected Optional<Vat> vat;
    protected Mixture cachedMixture;
    protected float heatingPower;
    protected float UVPower;
    protected LerpedFloat pressure = LerpedFloat.linear();
    protected LerpedFloat temperature = LerpedFloat.linear();
    protected VatFluidTankBehaviour tankBehaviour;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected BlockPos openVentPos = null;
    public SmartInventory inventory;
    protected LazyOptional<IItemHandler> itemCapability;
    protected boolean inventoryChanged;
    protected DestroyAdvancementBehaviour advancementBehaviour;
    protected int initializationTicks = 3;
    protected boolean underDeconstruction = false;
    public static final VatDisplaySource GAS_DISPLAY_SOURCE = new VatDisplaySource(false, "gas", v -> v.getGasTank().getFluid());
    public static final VatDisplaySource SOLUTION_DISPLAY_SOURCE = new VatDisplaySource(false, "solution", v -> v.getLiquidTank().getFluid());
    public static final VatDisplaySource ALL_DISPLAY_SOURCE = new VatDisplaySource(true, "all", v -> MixtureFluid.of(v.getCapacity(), v.cachedMixture));

    public VatControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.vat = Optional.empty();
        this.fluidCapability = LazyOptional.empty();
        this.itemCapability = LazyOptional.empty();
        this.updateItemCapability();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tankBehaviour = new VatFluidTankBehaviour(this, 1000000);
        this.tankBehaviour.whenFluidUpdates(this::onFluidStackChanged).forbidExtraction().forbidInsertion();
        this.fluidCapability = LazyOptional.empty();
        behaviours.add((BlockEntityBehaviour)this.tankBehaviour);
        this.advancementBehaviour = new DestroyAdvancementBehaviour(this);
        behaviours.add(this.advancementBehaviour);
    }

    protected void updateItemCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        this.inventory = new SmartInventory(9, (SyncedBlockEntity)this).whenContentsChanged(i -> this.setInventoryChanged());
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    protected void updateFluidCapability() {
        if (this.fluidCapability.isPresent()) {
            return;
        }
        this.fluidCapability = this.vat != null && this.vat.isPresent() ? LazyOptional.of(() -> (IFluidHandler)this.tankBehaviour.getCapability().orElse(null)) : LazyOptional.empty();
    }

    public void setInventoryChanged() {
        this.inventoryChanged = true;
    }

    protected AABB createRenderBoundingBox() {
        if (this.vat.isEmpty()) {
            return super.createRenderBoundingBox();
        }
        return this.wholeVatAABB();
    }

    public void tick() {
        super.tick();
        if (this.initializationTicks > 0) {
            --this.initializationTicks;
        }
        if (this.m_58904_().m_5776_()) {
            this.pressure.tickChaser();
            this.temperature.tickChaser();
        } else {
            VatSideBlockEntity openVent;
            if (this.getVatOptional().isEmpty()) {
                return;
            }
            boolean shouldUpdateFluidMixture = false;
            Vat vat = this.getVatOptional().get();
            if (this.tankBehaviour.isEmpty()) {
                return;
            }
            double fluidAmount = this.getCapacity() / 1000;
            int cyclesPerTick = VatControllerBlockEntity.getSimulationLevel();
            for (int cycle = 0; cycle < cyclesPerTick; ++cycle) {
                float energyChange = this.heatingPower;
                energyChange += (LevelPollution.getLocalTemperature(this.m_58904_(), this.m_58899_()) - this.cachedMixture.getTemperature()) * vat.getConductance();
                if (!(Math.abs((double)(energyChange /= (float)(20 * cyclesPerTick)) / (fluidAmount * (double)this.cachedMixture.getVolumetricHeatCapacity())) > (double)0.001f) || fluidAmount == 0.0) break;
                this.cachedMixture.heat(energyChange / (float)fluidAmount);
            }
            ArrayList<ItemStack> availableItemStacks = new ArrayList<ItemStack>();
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                availableItemStacks.add(stack.m_41777_());
            }
            Mixture.ReactionContext context = new Mixture.ReactionContext(availableItemStacks, this.UVPower);
            if (this.inventoryChanged) {
                this.cachedMixture.dissolveItems(context, fluidAmount);
                this.cachedMixture.disturbEquilibrium();
            }
            this.inventory.m_6211_();
            if (!this.cachedMixture.isAtEquilibrium()) {
                context = new Mixture.ReactionContext(availableItemStacks, this.UVPower);
                this.cachedMixture.reactForTick(context, VatControllerBlockEntity.getSimulationLevel());
                shouldUpdateFluidMixture = true;
                if (!this.cachedMixture.isAtEquilibrium()) {
                    this.advancementBehaviour.awardDestroyAdvancement(DestroyAdvancements.USE_VAT);
                }
            }
            for (ItemStack itemStack : availableItemStacks) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)itemStack, (boolean)false);
            }
            this.inventoryChanged = false;
            if (shouldUpdateFluidMixture) {
                this.cachedMixture.getCompletedResults(fluidAmount).entrySet().forEach(entry -> {
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        ((ReactionResult)entry.getKey()).onVatReaction(this.m_58904_(), this);
                    }
                });
                this.updateFluidMixture();
            }
            if ((openVent = this.getOpenVent()) != null && !this.getGasTank().isEmptyOrFullOfAir()) {
                PollutionHelper.pollute(this.m_58904_(), openVent.m_58899_().m_121945_(openVent.direction), 10, this.tankBehaviour.flush(this.cachedMixture.getTemperature()));
                this.updateCachedMixture();
            }
            if (((Boolean)DestroyAllConfigs.SERVER.contraptions.vatExplodesAtHighPressure.get()).booleanValue() && Math.abs(this.getPercentagePressure()) >= 1.0f) {
                this.explode();
            }
            this.sendData();
        }
    }

    public void explode() {
        this.explode((level, pos) -> new SmartExplosion((Level)level, null, null, null, (Vec3)pos, 5.0f, 0.6f));
    }

    public void explode(BiFunction<Level, Vec3, SmartExplosion> explosionFactory) {
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.getVatOptional().ifPresent(vat -> {
            Vec3 center = vat.getCenter();
            this.deleteVat(this.m_58899_());
            ExplosionHelper.explode(serverLevel, (SmartExplosion)((Object)((Object)explosionFactory.apply((Level)serverLevel, center))));
        });
    }

    public static int getSimulationLevel() {
        return (Integer)DestroyAllConfigs.SERVER.contraptions.simulationLevel.get();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.heatingPower = tag.m_128457_("HeatingPower");
        this.UVPower = tag.m_128457_("UVPower");
        if (tag.m_128425_("Vat", 10)) {
            this.vat = Vat.read(tag.m_128469_("Vat"));
            this.finalizeVatConstruction();
        } else {
            this.vat = Optional.empty();
        }
        this.underDeconstruction = tag.m_128471_("UnderDeconstruction");
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        this.inventoryChanged = tag.m_128471_("InventoryChanged");
        if (clientPacket) {
            this.pressure.chase((double)tag.m_128457_("Pressure"), 0.125, LerpedFloat.Chaser.EXP);
            this.temperature.chase((double)tag.m_128457_("Temperature"), 0.125, LerpedFloat.Chaser.EXP);
        } else {
            if (tag.m_128425_("VentPos", 10)) {
                this.openVentPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("VentPos"));
            }
            this.updateCachedMixture();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("HeatingPower", this.heatingPower);
        tag.m_128350_("UVPower", this.UVPower);
        if (this.vat.isPresent()) {
            CompoundTag vatTag = new CompoundTag();
            this.vat.get().write(vatTag);
            tag.m_128365_("Vat", (Tag)vatTag);
        }
        tag.m_128379_("UnderDeconstruction", this.underDeconstruction);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128379_("InventoryChanged", this.inventoryChanged);
        if (!this.m_58904_().m_5776_()) {
            tag.m_128350_("Pressure", this.getPressure());
            tag.m_128350_("Temperature", this.getTemperature());
        }
        if (this.openVentPos != null) {
            tag.m_128365_("VentPos", (Tag)NbtUtils.m_129224_((BlockPos)this.openVentPos));
        }
    }

    private void onFluidStackChanged() {
        if (!this.vat.isPresent()) {
            return;
        }
        this.notifyUpdate();
    }

    public Optional<Vat> getVatOptional() {
        return this.vat;
    }

    public boolean canFitFluid() {
        return this.vat.map(v -> !this.tankBehaviour.isFull()).orElse(false);
    }

    public int addFluid(FluidStack stack, IFluidHandler.FluidAction action) {
        int amountAdded = this.fluidCapability.map(fh -> fh.fill(stack, action)).orElse(0);
        if (amountAdded != 0 && action == IFluidHandler.FluidAction.EXECUTE) {
            this.updateCachedMixture();
            this.updateGasVolume();
            this.sendData();
        }
        return amountAdded;
    }

    public int getCapacity() {
        if (this.vat.isEmpty()) {
            return 0;
        }
        return this.vat.get().getCapacity();
    }

    public void updateCachedMixture() {
        Mixture emptyMixture = new Mixture();
        if (!this.getVatOptional().isPresent()) {
            this.cachedMixture = emptyMixture;
            return;
        }
        this.cachedMixture = this.tankBehaviour.getCombinedMixture();
    }

    private void updateFluidMixture() {
        if (this.getVatOptional().isEmpty()) {
            return;
        }
        this.tankBehaviour.setMixture(this.cachedMixture, this.vat.get().getCapacity());
        this.updateGasVolume();
        this.sendData();
    }

    public void updateGasVolume() {
        this.tankBehaviour.updateGasVolume();
    }

    public boolean tryMakeVat() {
        if (!this.m_58898_() || this.m_58904_().m_5776_()) {
            return false;
        }
        BlockPos vatInternalStartPos = new BlockPos((Vec3i)this.m_58899_().m_121945_(((Direction)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)VatControllerBlock.f_54117_)).m_122424_()));
        Optional<Vat> newVat = Vat.tryConstruct(this.m_58904_(), vatInternalStartPos, this.m_58899_());
        if (!newVat.isPresent()) {
            return false;
        }
        this.updateItemCapability();
        Collection<BlockPos> sides = newVat.get().getSideBlockPositions();
        sides.forEach(pos -> {
            BlockState oldState = this.m_58904_().m_8055_(pos);
            if (oldState.m_60713_((Block)DestroyBlocks.VAT_CONTROLLER.get())) {
                return;
            }
            this.m_58904_().m_46597_(pos, DestroyBlocks.VAT_SIDE.getDefaultState());
            this.m_58904_().m_141902_(pos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get()).ifPresent(vatSide -> {
                vatSide.direction = ((Vat)newVat.get()).whereIsSideFacing((BlockPos)pos);
                vatSide.setMaterial(oldState);
                vatSide.setConsumedItem(new ItemStack((ItemLike)oldState.m_60734_().m_5456_()));
                vatSide.controllerPosition = this.m_58899_();
                BlockPos adjacentPos = pos.m_121945_(vatSide.direction);
                vatSide.refreshFluidCapability();
                vatSide.updateDisplayType(adjacentPos);
                vatSide.setPowerFromAdjacentBlock(adjacentPos);
                vatSide.refreshItemCapability();
                vatSide.notifyUpdate();
            });
        });
        this.vat = Optional.of(newVat.get());
        this.finalizeVatConstruction();
        this.updateCachedMixture();
        this.tankBehaviour.flush(this.cachedMixture.getTemperature());
        this.updateCachedMixture();
        return true;
    }

    private void finalizeVatConstruction() {
        this.tankBehaviour.allowExtraction();
        this.tankBehaviour.setVatCapacity(this.vat.get().getCapacity());
        this.updateFluidCapability();
        this.invalidateRenderBoundingBox();
        this.notifyUpdate();
    }

    public void destroy() {
        this.deleteVat(this.m_58899_());
        super.destroy();
    }

    public void deleteVat(BlockPos posDestroyed) {
        if (this.underDeconstruction || this.m_58904_().m_5776_()) {
            return;
        }
        this.underDeconstruction = true;
        BlockPos pollutionPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)VatControllerBlock.f_54117_));
        Optional vatSideOptional = this.m_58904_().m_141902_(posDestroyed, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get());
        if (vatSideOptional.isPresent()) {
            pollutionPos = posDestroyed.m_121945_(((VatSideBlockEntity)((Object)vatSideOptional.get())).direction);
        }
        ItemHelper.dropContents((Level)this.m_58904_(), (BlockPos)posDestroyed, (IItemHandler)this.inventory);
        this.itemCapability.invalidate();
        PollutionHelper.pollute(this.m_58904_(), pollutionPos, this.getLiquidTank().getFluid(), this.getGasTank().getFluid());
        this.getLiquidTank().setFluid(FluidStack.EMPTY);
        this.getGasTank().setFluid(FluidStack.EMPTY);
        this.tankBehaviour.forbidExtraction();
        if (!this.vat.isPresent()) {
            return;
        }
        this.vat.get().getSideBlockPositions().forEach(pos -> {
            if (!pos.equals((Object)posDestroyed)) {
                this.m_58904_().m_141902_(pos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get()).ifPresent(vatSide -> {
                    BlockState newState = vatSide.getMaterial();
                    this.m_58904_().m_46597_(pos, newState);
                });
            }
        });
        this.heatingPower = 0.0f;
        this.UVPower = 0.0f;
        this.cachedMixture = new Mixture();
        this.vat = Optional.empty();
        this.underDeconstruction = false;
        this.invalidateRenderBoundingBox();
        this.notifyUpdate();
    }

    public VatFluidTankBehaviour.VatTankSegment.VatFluidTank getLiquidTank() {
        return this.tankBehaviour.getLiquidHandler();
    }

    public VatFluidTankBehaviour.VatTankSegment.VatFluidTank getGasTank() {
        return this.tankBehaviour.getGasHandler();
    }

    @Nullable
    public VatSideBlockEntity getOpenVent() {
        if (this.m_58904_() == null || this.openVentPos == null) {
            return null;
        }
        return this.m_58904_().m_141902_(this.openVentPos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get()).orElse(null);
    }

    public void removeVent() {
        this.openVentPos = null;
        if (!this.m_58898_() || this.getVatOptional().isEmpty()) {
            return;
        }
        this.getVatOptional().get().getSideBlockPositions().forEach(pos -> this.m_58904_().m_141902_(pos, (BlockEntityType)DestroyBlockEntityTypes.VAT_SIDE.get()).ifPresent(vatSide -> {
            if (vatSide.getDisplayType() == VatSideBlockEntity.DisplayType.OPEN_VENT) {
                this.openVentPos = pos;
            }
        }));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCapability.invalidate();
        this.itemCapability.invalidate();
    }

    public float getFluidLevel() {
        if (this.vat.isPresent()) {
            return (float)this.vat.get().getInternalHeight() * (float)this.getLiquidTank().getFluidAmount() / (float)this.getCapacity();
        }
        return 0.0f;
    }

    public float getRenderedFluidLevel(float partialTicks) {
        if (this.vat.isPresent()) {
            return (float)this.vat.get().getInternalHeight() * this.tankBehaviour.getLiquidTank().getTotalUnits(partialTicks) / (float)this.getCapacity();
        }
        return 0.0f;
    }

    public void changeHeatingPower(float powerChange) {
        this.heatingPower += powerChange;
        this.sendData();
    }

    public void changeUVPower(float UVChange) {
        this.UVPower += UVChange;
        this.sendData();
    }

    public ReadOnlyMixture getCombinedReadOnlyMixture() {
        return this.tankBehaviour.getCombinedReadOnlyMixture();
    }

    public float getClientTemperature(float partialTicks) {
        return this.temperature.getValue(partialTicks);
    }

    public float getClientPressure(float partialTicks) {
        return this.pressure.getValue(partialTicks);
    }

    public float getTemperature() {
        if (this.m_58904_().m_5776_()) {
            return this.temperature.getChaseTarget();
        }
        if (this.getVatOptional().isEmpty() || this.cachedMixture == null) {
            return LevelPollution.getLocalTemperature(this.m_58904_(), this.m_58899_());
        }
        return this.cachedMixture.getTemperature();
    }

    public float getPressure() {
        if (this.m_58904_().m_5776_()) {
            return this.pressure.getChaseTarget();
        }
        if (!this.getVatOptional().isPresent() || this.getOpenVent() != null) {
            return 0.0f;
        }
        if (this.getGasTank().isEmpty()) {
            return this.getLiquidTank().getFluidAmount() == this.getLiquidTank().getCapacity() ? 0.0f : 101000.0f;
        }
        return Reaction.GAS_CONSTANT.floatValue() * this.getTemperature() * ReadOnlyMixture.readNBT(ReadOnlyMixture::new, this.getGasTank().getFluid().getOrCreateChildTag("Mixture")).getTotalConcentration() - 101000.0f;
    }

    public float getPercentagePressure() {
        if (!this.getVatOptional().isPresent()) {
            return 0.0f;
        }
        Vat vat = this.getVatOptional().get();
        return this.getPressure() / vat.getMaxPressure();
    }

    public AABB wholeVatAABB() {
        return new AABB(this.vat.get().getInternalLowerCorner(), this.vat.get().getUpperCorner()).m_82400_(1.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void whenLookedAt(LocalPlayer player, BlockHitResult blockHitResult) {
        if (this.vat.isPresent()) {
            CreateClient.OUTLINER.showAABB((Object)Pair.of((Object)"vat", (Object)this.m_58899_()), this.wholeVatAABB(), 20).colored(-318);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getVatOptional().isPresent()) {
            VatControllerBlockEntity.vatFluidTooltip(this, tooltip);
        } else if (this.initializationTicks == 0) {
            TooltipHelper.cutTextComponent((Component)DestroyLang.translate("tooltip.vat.not_initialized", new Object[0]).component(), (TooltipHelper.Palette)TooltipHelper.Palette.RED).forEach(component -> DestroyLang.builder().add(component.m_6881_()).forGoggles(tooltip));
        }
        return true;
    }

    public static void vatFluidTooltip(VatControllerBlockEntity vatController, List<Component> tooltip) {
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.vat.contents_liquid", new Object[0]), vatController.getLiquidTank().getFluid(), vatController.getCapacity());
        DestroyLang.tankInfoTooltip(tooltip, DestroyLang.translate("tooltip.vat.contents_gas", new Object[0]), vatController.getGasTank().getFluid(), vatController.getCapacity());
    }

    public static class VatDisplaySource
    extends MixtureContentsDisplaySource {
        private final Function<VatControllerBlockEntity, FluidStack> fluidGetter;
        private final String tankId;

        private VatDisplaySource(boolean moles, String tankId, Function<VatControllerBlockEntity, FluidStack> fluidGetter) {
            super(moles);
            this.tankId = tankId;
            this.fluidGetter = fluidGetter;
        }

        @Override
        public FluidStack getFluidStack(DisplayLinkContext context) {
            VatControllerBlockEntity controller = null;
            BlockEntity be = context.getSourceBlockEntity();
            if (be instanceof VatControllerBlockEntity) {
                controller = (VatControllerBlockEntity)be;
            }
            if (be instanceof VatSideBlockEntity) {
                VatSideBlockEntity vatSide = (VatSideBlockEntity)be;
                controller = vatSide.getController();
            }
            if (controller == null) {
                return FluidStack.EMPTY;
            }
            return this.fluidGetter.apply(controller);
        }

        public Component getName() {
            return DestroyLang.translate("display_source.vat." + this.tankId, new Object[0]).component();
        }
    }
}

