/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity;

import com.petrolpark.destroy.block.DestroyBlocks;
import com.petrolpark.destroy.block.entity.VatControllerBlockEntity;
import com.petrolpark.destroy.capability.blockEntity.VatSideTankCapability;
import com.petrolpark.destroy.config.DestroyAllConfigs;
import com.petrolpark.destroy.util.DestroyLang;
import com.petrolpark.destroy.util.vat.IUVLampBlock;
import com.petrolpark.destroy.util.vat.IVatHeaterBlock;
import com.petrolpark.destroy.util.vat.Vat;
import com.petrolpark.destroy.util.vat.VatMaterial;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class VatSideBlockEntity
extends CopycatBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    private static final int BUFFER_TANK_CAPACITY = 1000;
    private static final DecimalFormat df = new DecimalFormat();
    protected SmartFluidTankBehaviour inputBehaviour;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected LazyOptional<IItemHandler> itemCapability;
    protected float oldPower = 0.0f;
    protected float oldUV = 0.0f;
    public Direction direction;
    public BlockPos controllerPosition;
    protected DisplayType displayType;
    public int spoutingTicks = 0;
    public FluidStack spoutingFluid;
    public LerpedFloat ventOpenness = LerpedFloat.linear().startWithValue(0.0);

    public VatSideBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.displayType = DisplayType.NORMAL;
        this.spoutingFluid = FluidStack.EMPTY;
        this.fluidCapability = LazyOptional.empty();
        this.itemCapability = LazyOptional.empty();
        this.refreshItemCapability();
        this.refreshFluidCapability();
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputBehaviour = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.TYPE, (SmartBlockEntity)this, 1, 1000, false).whenFluidUpdates(this::tryInsertFluidInVat).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.inputBehaviour);
        this.fluidCapability = LazyOptional.empty();
        this.refreshFluidCapability();
    }

    public void destroy() {
        super.destroy();
        VatControllerBlockEntity vatController = this.getController();
        if (vatController != null && !vatController.underDeconstruction) {
            vatController.deleteVat(this.m_58899_());
        }
    }

    protected void refreshFluidCapability() {
        if (this.fluidCapability.isPresent()) {
            return;
        }
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputBehaviour.getCapability();
            LazyOptional liquidOutputCap = LazyOptional.empty();
            LazyOptional gasOutputCap = LazyOptional.empty();
            VatControllerBlockEntity vatController = this.getController();
            if (vatController != null) {
                liquidOutputCap = LazyOptional.of(() -> vatController.getLiquidTank());
                gasOutputCap = LazyOptional.of(() -> vatController.getGasTank());
            }
            return new VatSideTankCapability(this, (IFluidHandler)liquidOutputCap.orElse(null), (IFluidHandler)gasOutputCap.orElse(null), (IFluidHandler)inputCap.orElse(null));
        });
    }

    protected void refreshItemCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        VatControllerBlockEntity vatController = this.getController();
        this.itemCapability = vatController != null ? vatController.itemCapability : LazyOptional.empty();
    }

    public void invalidateCaps() {
        this.fluidCapability.invalidate();
        this.itemCapability.invalidate();
    }

    @Nullable
    public VatControllerBlockEntity getController() {
        if (!this.m_58898_() || this.controllerPosition == null) {
            return null;
        }
        BlockEntity be = this.m_58904_().m_7702_(this.controllerPosition);
        if (!(be instanceof VatControllerBlockEntity)) {
            return null;
        }
        VatControllerBlockEntity vatController = (VatControllerBlockEntity)be;
        return vatController;
    }

    public Optional<Vat> getVatOptional() {
        VatControllerBlockEntity vatController = this.getController();
        if (vatController == null) {
            return Optional.empty();
        }
        return vatController.getVatOptional();
    }

    public void tryInsertFluidInVat() {
        VatControllerBlockEntity vatController = this.getController();
        if (vatController == null || this.inputBehaviour.getPrimaryHandler().isEmpty()) {
            return;
        }
        this.refreshFluidCapability();
        this.inputBehaviour.allowExtraction();
        FluidStack drainedFluid = this.inputBehaviour.getPrimaryHandler().drain(1000, IFluidHandler.FluidAction.SIMULATE);
        int drainedAmount = vatController.addFluid(drainedFluid, IFluidHandler.FluidAction.EXECUTE);
        this.inputBehaviour.getPrimaryHandler().drain(drainedAmount, IFluidHandler.FluidAction.EXECUTE);
        if (drainedAmount > 0) {
            this.spoutingTicks = 10;
            this.spoutingFluid = drainedFluid;
            this.sendData();
        }
        this.inputBehaviour.forbidExtraction();
    }

    public void tick() {
        super.tick();
        if (this.m_58904_().m_5776_()) {
            this.ventOpenness.tickChaser();
            if (this.spoutingTicks > 0) {
                --this.spoutingTicks;
                if (!this.isPipeSubmerged(true, null)) {
                    this.spawnParticles(this.spoutingFluid, this.m_58904_());
                }
            }
        }
        this.tryInsertFluidInVat();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.direction = tag.m_128441_("Side") ? Direction.values()[tag.m_128451_("Side")] : null;
        this.controllerPosition = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ControllerPosition"));
        this.displayType = DisplayType.values()[tag.m_128451_("DisplayType")];
        this.oldPower = tag.m_128457_("OldHeatingPower");
        this.oldUV = tag.m_128457_("OldUVPower");
        if (clientPacket) {
            this.spoutingTicks = tag.m_128451_("SpoutingTicks");
            this.spoutingFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("SpoutingFluid"));
            this.ventOpenness.chase(this.displayType == DisplayType.OPEN_VENT ? 1.0 : 0.0, (double)0.3f, LerpedFloat.Chaser.EXP);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.direction != null) {
            tag.m_128405_("Side", this.direction.ordinal());
        }
        if (this.controllerPosition != null) {
            tag.m_128365_("ControllerPosition", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPosition));
        }
        tag.m_128405_("DisplayType", this.displayType.ordinal());
        tag.m_128350_("OldHeatingPower", this.oldPower);
        tag.m_128350_("OldUVPower", this.oldUV);
        if (clientPacket) {
            tag.m_128405_("SpoutingTicks", this.spoutingTicks);
            if (!this.spoutingFluid.isEmpty()) {
                tag.m_128365_("SpoutingFluid", (Tag)this.spoutingFluid.writeToNBT(new CompoundTag()));
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != this.direction) {
            return LazyOptional.empty();
        }
        if (this.isFluidHandlerCap(cap) && (this.displayType == DisplayType.NORMAL || this.displayType == DisplayType.PIPE)) {
            return this.fluidCapability.cast();
        }
        if (this.isItemHandlerCap(cap)) {
            this.refreshItemCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public float getPercentagePressure() {
        VatControllerBlockEntity controller = this.getController();
        if (controller == null) {
            return 0.0f;
        }
        return controller.getPercentagePressure();
    }

    public float pipeHeightAboveVatBase() {
        if (this.getVatOptional().isEmpty() || this.direction == Direction.DOWN) {
            return 0.0f;
        }
        if (this.direction == Direction.UP) {
            return this.getVatOptional().get().getInternalHeight();
        }
        return (float)(this.m_58899_().m_123342_() - this.getVatOptional().get().getInternalLowerCorner().m_123342_()) + 0.25f;
    }

    public boolean isPipeSubmerged(boolean client, @Nullable Float partialTicks) {
        VatControllerBlockEntity controller = this.getController();
        if (controller == null) {
            return false;
        }
        if (this.direction == Direction.DOWN) {
            return true;
        }
        if (this.direction == Direction.UP) {
            return !controller.canFitFluid();
        }
        return this.pipeHeightAboveVatBase() < (client ? controller.getRenderedFluidLevel(partialTicks == null ? 0.0f : partialTicks.floatValue()) : controller.getFluidLevel());
    }

    public void setMaterial(BlockState blockState) {
        if (blockState.m_60713_((Block)DestroyBlocks.VAT_SIDE.get())) {
            return;
        }
        super.setMaterial(blockState);
    }

    public void setPowerFromAdjacentBlock(BlockPos heaterOrLampPos) {
        if (!this.m_58898_() | this.m_58904_().m_5776_()) {
            return;
        }
        VatControllerBlockEntity vatController = this.getController();
        if (vatController == null) {
            return;
        }
        float newPower = IVatHeaterBlock.getHeatingPower(this.m_58904_(), heaterOrLampPos, this.direction.m_122424_());
        if (newPower != this.oldPower) {
            vatController.changeHeatingPower(newPower - this.oldPower);
            this.oldPower = newPower;
        }
        float newUVPower = 0.0f;
        if (VatMaterial.getMaterial(this.getMaterial().m_60734_()).map(VatMaterial::transparent).orElse(false).booleanValue() && (newUVPower = IUVLampBlock.getUVPower(this.m_58904_(), heaterOrLampPos, this.direction.m_122424_())) == 0.0f && this.direction == Direction.UP && this.m_58904_().m_45527_(this.m_58899_())) {
            newUVPower = 10.0f;
        }
        if (newUVPower != this.oldUV) {
            vatController.changeUVPower(newUVPower - this.oldUV);
            this.oldUV = newUVPower;
        }
        this.sendData();
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        if (this.displayType == displayType) {
            return;
        }
        boolean updateVent = this.displayType == DisplayType.OPEN_VENT;
        this.displayType = displayType;
        if (!this.m_58898_()) {
            return;
        }
        if (this.m_58904_().m_5776_()) {
            this.ventOpenness.chase(displayType == DisplayType.OPEN_VENT ? 1.0 : 0.0, (double)0.3f, LerpedFloat.Chaser.EXP);
        }
        this.m_58900_().m_60701_((LevelAccessor)this.m_58904_(), this.m_58899_(), 3);
        this.updateDisplayType(this.m_58899_().m_121945_(this.direction));
        this.sendData();
        VatControllerBlockEntity controller = this.getController();
        if (controller == null) {
            return;
        }
        if (updateVent) {
            controller.removeVent();
        }
        if (displayType == DisplayType.OPEN_VENT) {
            if (controller.cachedMixture != null) {
                controller.cachedMixture.disturbEquilibrium();
            }
            if (controller.openVentPos == null) {
                controller.openVentPos = this.m_58899_();
            }
        }
    }

    public void updateDisplayType(BlockPos neighborPos) {
        FluidTransportBehaviour.AttachmentTypes attachment;
        if (this.getController() == null) {
            return;
        }
        FluidTransportBehaviour behaviour = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)this.m_58904_(), (BlockPos)neighborPos, (BehaviourType)FluidTransportBehaviour.TYPE);
        boolean nextToPipe = false;
        if (behaviour != null && ((attachment = behaviour.getRenderedRimAttachment((BlockAndTintGetter)this.m_58904_(), neighborPos, behaviour.blockEntity.m_58900_(), this.direction.m_122424_())) == FluidTransportBehaviour.AttachmentTypes.DRAIN || attachment == FluidTransportBehaviour.AttachmentTypes.PARTIAL_DRAIN)) {
            nextToPipe = true;
        }
        boolean nextToAir = this.m_58904_().m_8055_(neighborPos).m_60795_();
        if (nextToPipe) {
            this.setDisplayType(DisplayType.PIPE);
        } else if (!nextToAir) {
            this.setDisplayType(DisplayType.NORMAL);
        } else {
            if (this.getDisplayType() == DisplayType.PIPE) {
                this.setDisplayType(DisplayType.NORMAL);
            }
            switch (this.direction) {
                case UP: {
                    if (this.getDisplayType().validForTop()) break;
                    this.setDisplayType(DisplayType.NORMAL);
                    break;
                }
                case DOWN: {
                    if (this.getDisplayType().validForBottom()) break;
                    this.setDisplayType(DisplayType.NORMAL);
                    break;
                }
                default: {
                    if (this.getDisplayType().validForSide()) break;
                    this.setDisplayType(DisplayType.NORMAL);
                }
            }
        }
        this.invalidateRenderBoundingBox();
    }

    public void updateRedstone() {
        if (!this.m_58898_()) {
            return;
        }
        boolean hasPower = this.m_58904_().m_276867_(this.m_58899_());
        if (this.getDisplayType() == DisplayType.OPEN_VENT && hasPower) {
            this.setDisplayType(DisplayType.CLOSED_VENT);
        }
        if (this.getDisplayType() == DisplayType.CLOSED_VENT && !hasPower) {
            this.setDisplayType(DisplayType.OPEN_VENT);
        }
    }

    protected void spawnParticles(FluidStack fluid, Level level) {
        if (this.isVirtual()) {
            return;
        }
        Vec3 position = VecHelper.getCenterOf((Vec3i)this.m_58899_().m_121945_(this.direction.m_122424_())).m_82492_(0.0, this.direction == Direction.UP ? 0.0 : 0.1875, 0.0).m_82549_(Vec3.m_82528_((Vec3i)this.direction.m_122436_()).m_82490_(0.1875));
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.05f);
        motion = new Vec3(motion.f_82479_, Math.abs((double)motion.f_82480_), motion.f_82481_);
        level.m_7107_(particle, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VatControllerBlockEntity controller = this.getController();
        if (!this.getVatOptional().isPresent() || controller == null) {
            return false;
        }
        switch (this.getDisplayType()) {
            case THERMOMETER: {
                DestroyLang.TemperatureUnit unit = (DestroyLang.TemperatureUnit)((Object)DestroyAllConfigs.CLIENT.chemistry.temperatureUnit.get());
                DestroyLang.translate("tooltip.vat.temperature", unit.of(controller.getTemperature(), df)).style(ChatFormatting.WHITE).forGoggles(tooltip);
                if (!((Boolean)DestroyAllConfigs.CLIENT.chemistry.nerdMode.get()).booleanValue()) break;
                DestroyLang.translate("tooltip.vat.power", df.format(controller.heatingPower / 1000.0f)).forGoggles(tooltip);
                break;
            }
            case BAROMETER: {
                Vat vat = this.getVatOptional().get();
                DestroyLang.translate("tooltip.vat.pressure.header", new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
                DestroyLang.translate("tooltip.vat.pressure.current", df.format(controller.getPressure() / 1000.0f)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                DestroyLang.translate("tooltip.vat.pressure.max", df.format(vat.getMaxPressure() / 1000.0f), vat.getWeakestBlock().m_60734_().m_49954_().getString()).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                break;
            }
            default: {
                VatControllerBlockEntity.vatFluidTooltip(this.getController(), tooltip);
            }
        }
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getDisplayType() == DisplayType.PIPE && !this.isPipeSubmerged(false, null)) {
            DestroyLang.translate("tooltip.vat.not_submerged.header", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            TooltipHelper.cutTextComponent((Component)DestroyLang.translate("tooltip.vat.not_submerged", new Object[0]).component(), (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE).forEach(component -> DestroyLang.builder().add(component.m_6881_()).forGoggles(tooltip));
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        return false;
    }

    static {
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
    }

    public static enum DisplayType {
        NORMAL,
        BAROMETER,
        THERMOMETER,
        PIPE,
        CLOSED_VENT,
        OPEN_VENT;


        public boolean validForTop() {
            return this != BAROMETER && this != THERMOMETER;
        }

        public boolean validForBottom() {
            return this.validForTop() && this != CLOSED_VENT && this != OPEN_VENT;
        }

        public boolean validForSide() {
            return this != OPEN_VENT && this != CLOSED_VENT;
        }

        public boolean isVent() {
            return this == CLOSED_VENT || this == OPEN_VENT;
        }
    }
}

