/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour;

import com.petrolpark.destroy.block.entity.behaviour.BeltChargingCallbacks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChargingBehaviour
extends BeltProcessingBehaviour {
    public static final int CHARGING_TIME = 240;
    public static final int ENTITY_SCAN_TIME = 10;
    public ChargingBehaviourSpecifics specifics;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    public Vec3 targetPosition;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> ChargingBehaviour(T be) {
        super(be);
        this.specifics = (ChargingBehaviourSpecifics)be;
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.targetPosition = Vec3.m_82539_((Vec3i)be.m_58899_().m_7495_());
        this.whenItemEnters((s, i) -> BeltChargingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltChargingCallbacks.whenItemHeld(s, i, this));
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        this.running = tag.m_128471_("Running");
        this.mode = Mode.values()[tag.m_128451_("Mode")];
        this.finished = tag.m_128471_("Finished");
        this.runningTicks = tag.m_128451_("Ticks");
        if (clientPacket) {
            this.targetPosition = VecHelper.readNBT((ListTag)tag.m_128437_("Target", 6));
        }
        super.read(tag, clientPacket);
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128379_("Running", this.running);
        tag.m_128405_("Mode", this.mode.ordinal());
        tag.m_128379_("Finished", this.finished);
        tag.m_128405_("Ticks", this.runningTicks);
        if (clientPacket) {
            tag.m_128365_("Target", (Tag)VecHelper.writeNBT((Vec3)this.targetPosition));
        }
        super.write(tag, clientPacket);
    }

    public void start(Mode mode, Vec3 targetPosition) {
        this.mode = mode;
        this.running = true;
        this.runningTicks = 0;
        this.targetPosition = targetPosition;
        this.blockEntity.sendData();
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        if (level == null) {
            return;
        }
        if (!this.running) {
            if (!level.m_5776_()) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos.m_6625_(2), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (AllBlocks.BASIN.has(level.m_8055_(pos.m_6625_(2)))) {
                        return;
                    }
                    for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, new AABB(pos.m_7495_()).m_82406_(0.125))) {
                        if (!itemEntity.m_6084_() || !itemEntity.m_20096_() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD, itemEntity.m_20182_().m_82520_(0.0, (double)0.1f, 0.0));
                        return;
                    }
                }
            }
            return;
        }
        if (this.runningTicks == 240 && this.specifics.getKineticSpeed() != 0.0f) {
            switch (this.mode) {
                case BASIN: {
                    this.applyOnBasin();
                }
                case WORLD: {
                    this.applyInWorld();
                }
                case BELT: {
                    if (level.m_5776_()) break;
                    this.blockEntity.sendData();
                }
            }
        }
        if (!level.f_46443_ && this.runningTicks >= 240) {
            this.finished = true;
            this.running = false;
            this.specifics.onChargingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.runningTicks += this.getRunningTickSpeed();
        if (this.runningTicks >= 240) {
            this.runningTicks = 240;
        }
    }

    protected void applyOnBasin() {
        Level level = this.getWorld();
        if (level.m_5776_()) {
            return;
        }
        if (this.specifics.tryProcessInBasin(false)) {
            this.blockEntity.sendData();
        }
    }

    protected void applyInWorld() {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        AABB bb = new AABB(pos.m_6625_(1));
        boolean bulk = this.specifics.canProcessInBulk();
        if (level.m_5776_()) {
            return;
        }
        for (Entity entity : level.m_45933_(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.m_6084_() || !entity.m_20096_()) continue;
            this.entityScanCooldown = 0;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public static interface ChargingBehaviourSpecifics {
        public boolean tryProcessInBasin(boolean var1);

        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public boolean canProcessInBulk();

        public void onChargingCompleted();

        public float getKineticSpeed();
    }

    public static enum Mode {
        WORLD,
        BELT,
        BASIN;

    }
}

