/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.destroy.block.entity.behaviour;

import com.petrolpark.destroy.chemistry.Reaction;
import com.petrolpark.destroy.chemistry.ReactionResult;
import com.petrolpark.destroy.util.PollutionHelper;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class ExtendedBasinBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ExtendedBasinBehaviour> TYPE = new BehaviourType();
    public boolean tooFullToReact = false;
    private Map<ReactionResult, Integer> reactionResults = new HashMap<ReactionResult, Integer>();
    public FluidStack evaporatedFluid = FluidStack.EMPTY;

    public ExtendedBasinBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void setReactionResults(Map<ReactionResult, Integer> results) {
        this.reactionResults = results;
    }

    public void tick() {
        BasinBlockEntity basin;
        if (!this.blockEntity.m_58898_()) {
            return;
        }
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (!(smartBlockEntity instanceof BasinBlockEntity) || (basin = (BasinBlockEntity)smartBlockEntity).m_58904_().m_5776_()) {
            return;
        }
        BlockEntity potentialOperator = this.getWorld().m_7702_(this.getPos().m_6630_(2));
        if (potentialOperator instanceof MechanicalMixerBlockEntity) {
            MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)potentialOperator;
            if (mixer.processingTicks == 1) {
                this.enactReactionResults(basin);
            }
        }
    }

    public void enactReactionResults(BasinBlockEntity basin) {
        for (ReactionResult result : this.reactionResults.keySet()) {
            for (int i = 0; i < this.reactionResults.get(result); ++i) {
                result.onBasinReaction(basin.m_58904_(), basin);
            }
        }
        this.reactionResults.clear();
        if (!this.evaporatedFluid.isEmpty()) {
            PollutionHelper.pollute(basin.m_58904_(), basin.m_58899_(), this.evaporatedFluid);
            this.evaporatedFluid = FluidStack.EMPTY;
        }
    }

    public void destroy() {
        Level level;
        if (!this.evaporatedFluid.isEmpty() && (level = this.blockEntity.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PollutionHelper.pollute((Level)serverLevel, this.blockEntity.m_58899_(), this.evaporatedFluid);
            this.evaporatedFluid = FluidStack.EMPTY;
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.tooFullToReact = nbt.m_128471_("TooFullToReact");
        this.reactionResults = new HashMap<ReactionResult, Integer>();
        ListTag results = nbt.m_128437_("Results", 10);
        results.forEach(tag -> {
            CompoundTag resultTag = (CompoundTag)tag;
            ReactionResult result = Reaction.get(resultTag.m_128461_("Result")).getResult();
            int number = resultTag.m_128451_("Count");
            if (result == null) {
                return;
            }
            this.reactionResults.put(result, number);
        });
        this.evaporatedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("EvaporatedFluidStack"));
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128379_("TooFullToReact", this.tooFullToReact);
        nbt.m_128365_("Results", (Tag)NBTHelper.writeCompoundList(this.reactionResults.entrySet(), entry -> {
            CompoundTag resultTag = new CompoundTag();
            resultTag.m_128359_("Result", ((ReactionResult)entry.getKey()).getReaction().getFullId());
            resultTag.m_128405_("Count", ((Integer)entry.getValue()).intValue());
            return resultTag;
        }));
        CompoundTag fluidTag = new CompoundTag();
        this.evaporatedFluid.writeToNBT(fluidTag);
        nbt.m_128365_("EvaporatedFluid", (Tag)fluidTag);
    }
}

